/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.rple.api.client.lightmap.vanilla;

import com.falsepattern.rple.api.client.lightmap.RPLELightMapMask;
import com.falsepattern.rple.api.client.lightmap.RPLELightMapStrip;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EntityRenderer;
import org.jetbrains.annotations.NotNull;

public class BossColorModifierMask
implements RPLELightMapMask {
    @Override
    public void mutateBlockLightMap(@NotNull RPLELightMapStrip output, float partialTick) {
        this.mutateLightMap(output, partialTick);
    }

    @Override
    public void mutateSkyLightMap(@NotNull RPLELightMapStrip output, float partialTick) {
        this.mutateLightMap(output, partialTick);
    }

    protected void mutateLightMap(RPLELightMapStrip output, float partialTick) {
        EntityRenderer entityRenderer = Minecraft.func_71410_x().field_71460_t;
        if (entityRenderer == null || entityRenderer.field_82831_U <= 0.0f) {
            return;
        }
        float mod = entityRenderer.field_82832_V + (entityRenderer.field_82831_U - entityRenderer.field_82832_V) * partialTick;
        float modInv = 1.0f - mod;
        float modDarkR = 0.7f * mod;
        float modDarkGB = 0.6f * mod;
        float[] R = output.lightMapRedData();
        float[] G = output.lightMapGreenData();
        float[] B = output.lightMapBlueData();
        for (int i = 0; i < 16; ++i) {
            float r = R[i];
            float g = G[i];
            float b = B[i];
            R[i] = r * modInv + r * modDarkR;
            G[i] = g * modInv + g * modDarkGB;
            B[i] = b * modInv + b * modDarkGB;
        }
    }

    protected float bossColorModifierIntensity(EntityRenderer entityRenderer, float partialTick) {
        return entityRenderer.field_82832_V + (entityRenderer.field_82831_U - entityRenderer.field_82832_V) * partialTick;
    }
}

