/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.rple.internal.asm;

import java.util.ListIterator;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class TextureStateTrackerInjector
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (basicClass == null) {
            return null;
        }
        if (transformedName.startsWith("com.falsepattern.rple.") || transformedName.startsWith("org.lwjgl.") || transformedName.startsWith("org.lwjglx.")) {
            return basicClass;
        }
        ClassNode cn = new ClassNode();
        new ClassReader(basicClass).accept((ClassVisitor)cn, 0);
        boolean modified = false;
        for (MethodNode method : cn.methods) {
            ListIterator iter = method.instructions.iterator();
            while (iter.hasNext()) {
                AbstractInsnNode insn = (AbstractInsnNode)iter.next();
                if (insn.getOpcode() != 184 || !(insn instanceof MethodInsnNode)) continue;
                MethodInsnNode mInsn = (MethodInsnNode)insn;
                if ("org.lwjgl.opengl.GL11".equals(mInsn.owner) || "org.lwjglx.opengl.GL11".equals(mInsn.owner)) continue;
                boolean isEnable = "glEnable".equals(mInsn.name);
                if (isEnable || "glDisable".equals(mInsn.name)) {
                    AbstractInsnNode previous = mInsn.getPrevious();
                    if (previous.getOpcode() != 17 && !(previous instanceof IntInsnNode)) continue;
                    IntInsnNode intInsn = (IntInsnNode)previous;
                    if (intInsn.operand != 3553) continue;
                    iter.previous();
                    iter.add(new MethodInsnNode(184, "com/falsepattern/rple/internal/client/lightmap/LightMapStateMachine", isEnable ? "enableTex" : "disableTex", "()V", false));
                    iter.next();
                    modified = true;
                    continue;
                }
                if (!"glMatrixMode".equals(mInsn.name)) continue;
                iter.previous();
                iter.add(new InsnNode(89));
                iter.add(new FieldInsnNode(179, "com/falsepattern/rple/internal/client/lightmap/LightMap", "extMatrixMode", "I"));
                iter.next();
                modified = true;
            }
        }
        if (modified) {
            ClassWriter writer = new ClassWriter(0);
            cn.accept((ClassVisitor)writer);
            return writer.toByteArray();
        }
        return basicClass;
    }
}

