/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.rple.internal.client.lamp;

import com.falsepattern.falsetweaks.api.PassTrackingTessellator;
import com.falsepattern.rple.api.client.ClientColorHelper;
import com.falsepattern.rple.api.client.RPLETessBrightnessUtil;
import com.falsepattern.rple.api.common.ServerColorHelper;
import com.falsepattern.rple.internal.Compat;
import com.falsepattern.rple.internal.common.lamp.LampBlock;
import com.falsepattern.rple.internal.common.util.FastThreadLocal;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;

public class LampRenderer
implements ISimpleBlockRenderingHandler {
    public static final int RENDER_ID = RenderingRegistry.getNextAvailableRenderId();
    private static final float OFFSET = 0.05f;
    private static final int DGC_MASK_X_POS = LampRenderer.toBitMask(2, 1, 1);
    private static final int DGC_MASK_X_NEG = LampRenderer.toBitMask(0, 1, 1);
    private static final int DGC_MASK_Y_POS = LampRenderer.toBitMask(1, 2, 1);
    private static final int DGC_MASK_Y_NEG = LampRenderer.toBitMask(1, 0, 1);
    private static final int DGC_MASK_Z_POS = LampRenderer.toBitMask(1, 1, 2);
    private static final int DGC_MASK_Z_NEG = LampRenderer.toBitMask(1, 1, 0);
    private static final int DGC_MASK_ALL = DGC_MASK_X_POS | DGC_MASK_X_NEG | DGC_MASK_Y_POS | DGC_MASK_Y_NEG | DGC_MASK_Z_POS | DGC_MASK_Z_NEG;
    private static final Sampler XPosSampler = (neighbors, x, y, forward) -> LampRenderer.getNeighbor(neighbors, 1 + forward, y, x);
    private static final Sampler XNegSampler = (neighbors, x, y, forward) -> LampRenderer.getNeighbor(neighbors, 1 - forward, y, x);
    private static final Sampler YPosSampler = (neighbors, x, y, forward) -> LampRenderer.getNeighbor(neighbors, y, 1 + forward, x);
    private static final Sampler YNegSampler = (neighbors, x, y, forward) -> LampRenderer.getNeighbor(neighbors, y, 1 - forward, x);
    private static final Sampler ZPosSampler = (neighbors, x, y, forward) -> LampRenderer.getNeighbor(neighbors, y, x, 1 + forward);
    private static final Sampler ZNegSampler = (neighbors, x, y, forward) -> LampRenderer.getNeighbor(neighbors, y, x, 1 - forward);
    private static final FastThreadLocal.FixedValue<SegmentBuffer> S_BUF = new FastThreadLocal.FixedValue<SegmentBuffer>(() -> new SegmentBuffer());

    public void renderInventoryBlock(Block block, int meta, int modelId, RenderBlocks renderer) {
        block.func_149683_g();
        renderer.func_147775_a(block);
        GL11.glPushAttrib((int)64);
        GL11.glPushMatrix();
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        Tessellator tessellator = Compat.tessellator();
        tessellator.func_78382_b();
        tessellator.func_78370_a(255, 255, 255, 255);
        boolean glowing = LampBlock.isGlowing(meta);
        if (glowing) {
            RPLETessBrightnessUtil.setLightMapTextureCoordsRGB64(ClientColorHelper.RGB64FromVanillaMonochrome(ClientColorHelper.vanillaFromBlockSky4Bit(15, 0)));
        }
        IIcon icon = block.func_149691_a(0, meta);
        LampRenderer.drawCubeInventory(tessellator, renderer, block, 0.0, 0.0, 0.0, icon);
        tessellator.func_78381_a();
        GL11.glDisable((int)2896);
        tessellator.func_78382_b();
        if (glowing) {
            LampBlock lamp = (LampBlock)block;
            short color = lamp.getColor();
            int r = ServerColorHelper.red(color) * 17;
            int g = ServerColorHelper.green(color) * 17;
            int b = ServerColorHelper.blue(color) * 17;
            tessellator.func_78370_a(r, g, b, 128);
            LampRenderer.drawGlowCube(tessellator, 0.0, 0.0, 0.0, 0, lamp.getGlowIcon());
            tessellator.func_78370_a(255, 255, 255, 255);
        }
        tessellator.func_78381_a();
        GL11.glPopMatrix();
        GL11.glPopAttrib();
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        boolean inverted;
        LampBlock lamp = (LampBlock)block;
        Tessellator tessellator = Compat.tessellator();
        int renderPass = ((PassTrackingTessellator)tessellator).pass();
        if (renderPass == 0) {
            return renderer.func_147784_q((Block)lamp, x, y, z);
        }
        if (renderPass != 1) {
            return false;
        }
        int meta = world.func_72805_g(x, y, z);
        boolean powered = (meta & 2) != 0;
        boolean bl = inverted = (meta & 1) != 0;
        if (powered == inverted) {
            return false;
        }
        int neighbors = 0;
        for (int Z = 0; Z <= 2; ++Z) {
            for (int Y = 0; Y <= 2; ++Y) {
                for (int X = 0; X <= 2; ++X) {
                    if (X == 1 && Y == 1 && Z == 1) continue;
                    int BX = X - 1 + x;
                    int BY = Y - 1 + y;
                    int BZ = Z - 1 + z;
                    if (BY >= 256 || BY < 0 || !LampRenderer.isBlockGlowingLamp(world, BX, BY, BZ)) continue;
                    neighbors = LampRenderer.setNeighbor(neighbors, X, Y, Z);
                }
            }
        }
        short color = lamp.getColor();
        int r = ServerColorHelper.red(color) * 17;
        int g = ServerColorHelper.green(color) * 17;
        int b = ServerColorHelper.blue(color) * 17;
        tessellator.func_78380_c(ClientColorHelper.vanillaFromBlockSky4Bit(15, 15));
        tessellator.func_78376_a(r, g, b);
        LampRenderer.drawGlowCube(tessellator, x, y, z, neighbors, lamp.getGlowIcon());
        return true;
    }

    private static int toShift(int X, int Y, int Z) {
        return X * 9 + Y * 3 + Z;
    }

    private static int toBitMask(int X, int Y, int Z) {
        return 1 << LampRenderer.toShift(X, Y, Z);
    }

    private static int setNeighbor(int neighbors, int X, int Y, int Z) {
        return neighbors | LampRenderer.toBitMask(X, Y, Z);
    }

    private static boolean getNeighbor(int neighbors, int X, int Y, int Z) {
        return (neighbors & LampRenderer.toBitMask(X, Y, Z)) != 0;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return RENDER_ID;
    }

    private static boolean isBlockGlowingLamp(IBlockAccess world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (!(block instanceof LampBlock)) {
            return false;
        }
        int meta = world.func_72805_g(x, y, z);
        boolean powered = (meta & 2) != 0;
        boolean inverted = (meta & 1) != 0;
        return powered != inverted;
    }

    private static void drawCubeInventory(Tessellator tessellator, RenderBlocks renderer, Block block, double x, double y, double z, IIcon texture) {
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        renderer.func_147768_a(block, x, y, z, texture);
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        renderer.func_147806_b(block, x, y, z, texture);
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        renderer.func_147761_c(block, x, y, z, texture);
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        renderer.func_147734_d(block, x, y, z, texture);
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        renderer.func_147798_e(block, x, y, z, texture);
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        renderer.func_147764_f(block, x, y, z, texture);
    }

    private static void drawGlowCube(Tessellator tessellator, double x, double y, double z, int neighbors, IIcon icon) {
        if ((neighbors & DGC_MASK_ALL) == DGC_MASK_ALL) {
            return;
        }
        SegmentBuffer sBuf = S_BUF.get();
        if ((neighbors & DGC_MASK_X_POS) == 0) {
            LampRenderer.drawXPos(sBuf, tessellator, x, y, z, neighbors, icon);
        }
        if ((neighbors & DGC_MASK_X_NEG) == 0) {
            LampRenderer.drawXNeg(sBuf, tessellator, x, y, z, neighbors, icon);
        }
        if ((neighbors & DGC_MASK_Y_POS) == 0) {
            LampRenderer.drawYPos(sBuf, tessellator, x, y, z, neighbors, icon);
        }
        if ((neighbors & DGC_MASK_Y_NEG) == 0) {
            LampRenderer.drawYNeg(sBuf, tessellator, x, y, z, neighbors, icon);
        }
        if ((neighbors & DGC_MASK_Z_POS) == 0) {
            LampRenderer.drawZPos(sBuf, tessellator, x, y, z, neighbors, icon);
        }
        if ((neighbors & DGC_MASK_Z_NEG) == 0) {
            LampRenderer.drawZNeg(sBuf, tessellator, x, y, z, neighbors, icon);
        }
    }

    private static void drawXPos(SegmentBuffer sBuf, Tessellator tessellator, double x, double y, double z, int neighbors, IIcon icon) {
        float[][] segments = sBuf.result;
        int sCount = LampRenderer.genSegments(sBuf, neighbors, XPosSampler);
        for (int i = 0; i < sCount; ++i) {
            float[] segment = segments[i];
            LampRenderer.drawXPos(tessellator, y + (double)segment[1], y + (double)segment[3], z + (double)segment[0], z + (double)segment[2], x + 1.0 + (double)0.05f, icon);
        }
    }

    private static void drawXNeg(SegmentBuffer sBuf, Tessellator tessellator, double x, double y, double z, int neighbors, IIcon icon) {
        float[][] segments = sBuf.result;
        int sCount = LampRenderer.genSegments(sBuf, neighbors, XNegSampler);
        for (int i = 0; i < sCount; ++i) {
            float[] segment = segments[i];
            LampRenderer.drawXNeg(tessellator, y + (double)segment[1], y + (double)segment[3], z + (double)segment[0], z + (double)segment[2], x - (double)0.05f, icon);
        }
    }

    private static void drawYPos(SegmentBuffer sBuf, Tessellator tessellator, double x, double y, double z, int neighbors, IIcon icon) {
        float[][] segments = sBuf.result;
        int sCount = LampRenderer.genSegments(sBuf, neighbors, YPosSampler);
        for (int i = 0; i < sCount; ++i) {
            float[] segment = segments[i];
            LampRenderer.drawYPos(tessellator, x + (double)segment[1], x + (double)segment[3], z + (double)segment[0], z + (double)segment[2], y + 1.0 + (double)0.05f, icon);
        }
    }

    private static void drawYNeg(SegmentBuffer sBuf, Tessellator tessellator, double x, double y, double z, int neighbors, IIcon icon) {
        float[][] segments = sBuf.result;
        int sCount = LampRenderer.genSegments(sBuf, neighbors, YNegSampler);
        for (int i = 0; i < sCount; ++i) {
            float[] segment = segments[i];
            LampRenderer.drawYNeg(tessellator, x + (double)segment[1], x + (double)segment[3], z + (double)segment[0], z + (double)segment[2], y - (double)0.05f, icon);
        }
    }

    private static void drawZPos(SegmentBuffer sBuf, Tessellator tessellator, double x, double y, double z, int neighbors, IIcon icon) {
        float[][] segments = sBuf.result;
        int sCount = LampRenderer.genSegments(sBuf, neighbors, ZPosSampler);
        for (int i = 0; i < sCount; ++i) {
            float[] segment = segments[i];
            LampRenderer.drawZPos(tessellator, x + (double)segment[1], x + (double)segment[3], y + (double)segment[0], y + (double)segment[2], z + 1.0 + (double)0.05f, icon);
        }
    }

    private static void drawZNeg(SegmentBuffer sBuf, Tessellator tessellator, double x, double y, double z, int neighbors, IIcon icon) {
        float[][] segments = sBuf.result;
        int sCount = LampRenderer.genSegments(sBuf, neighbors, ZNegSampler);
        for (int i = 0; i < sCount; ++i) {
            float[] segment = segments[i];
            LampRenderer.drawZNeg(tessellator, x + (double)segment[1], x + (double)segment[3], y + (double)segment[0], y + (double)segment[2], z - (double)0.05f, icon);
        }
    }

    private static int genSegments(SegmentBuffer sBuf, int neighbors, Sampler sampler) {
        sBuf.init();
        float[] center = sBuf.center;
        float[] xMin = sBuf.xMin;
        float[] xMax = sBuf.xMax;
        if (sampler.sample(neighbors, 1, 2, 0)) {
            xMin[3] = 1.0f;
            center[3] = 1.0f;
            xMax[3] = 1.0f;
        }
        if (sampler.sample(neighbors, 1, 0, 0)) {
            xMin[1] = 0.0f;
            center[1] = 0.0f;
            xMax[1] = 0.0f;
        }
        if (sampler.sample(neighbors, 2, 1, 0)) {
            xMax[2] = 1.0f;
        }
        if (sampler.sample(neighbors, 0, 1, 0)) {
            xMin[0] = 0.0f;
        }
        if (sampler.sample(neighbors, 0, 0, 0)) {
            xMin[1] = 0.0f;
        }
        if (sampler.sample(neighbors, 2, 0, 0)) {
            xMax[1] = 0.0f;
        }
        if (sampler.sample(neighbors, 0, 2, 0)) {
            xMin[3] = 1.0f;
        }
        if (sampler.sample(neighbors, 2, 2, 0)) {
            xMax[3] = 1.0f;
        }
        if (sampler.sample(neighbors, 0, 0, 1)) {
            xMin[1] = 0.05f;
        }
        if (sampler.sample(neighbors, 2, 0, 1)) {
            xMax[1] = 0.05f;
        }
        if (sampler.sample(neighbors, 0, 2, 1)) {
            xMin[3] = 0.95f;
        }
        if (sampler.sample(neighbors, 2, 2, 1)) {
            xMax[3] = 0.95f;
        }
        if (sampler.sample(neighbors, 1, 0, 1)) {
            xMin[1] = 0.05f;
            center[1] = 0.05f;
            xMax[1] = 0.05f;
        }
        if (sampler.sample(neighbors, 1, 2, 1)) {
            xMin[3] = 0.95f;
            center[3] = 0.95f;
            xMax[3] = 0.95f;
        }
        if (sampler.sample(neighbors, 0, 1, 1)) {
            xMin = null;
        }
        if (sampler.sample(neighbors, 2, 1, 1)) {
            xMax = null;
        }
        return LampRenderer.merge(sBuf, xMin, center, xMax);
    }

    private static int merge(SegmentBuffer sBuf, float[] xMin, float[] center, float[] xMax) {
        if (xMin != null && xMin[1] == center[1] && xMin[3] == center[3]) {
            center[0] = xMin[0];
            xMin = null;
        }
        if (xMax != null && center[1] == xMax[1] && center[3] == xMax[3]) {
            center[2] = xMax[2];
            xMax = null;
        }
        float[][] result = sBuf.result;
        int i = 0;
        if (xMin != null) {
            result[i] = xMin;
            ++i;
        }
        result[i] = center;
        ++i;
        if (xMax != null) {
            result[i] = xMax;
            ++i;
        }
        return i;
    }

    private static void drawXPos(Tessellator tessellator, double minY, double maxY, double minZ, double maxZ, double x, IIcon icon) {
        tessellator.func_78374_a(x, maxY, minZ, (double)icon.func_94212_f(), (double)icon.func_94206_g());
        tessellator.func_78374_a(x, maxY, maxZ, (double)icon.func_94209_e(), (double)icon.func_94206_g());
        tessellator.func_78374_a(x, minY, maxZ, (double)icon.func_94209_e(), (double)icon.func_94210_h());
        tessellator.func_78374_a(x, minY, minZ, (double)icon.func_94212_f(), (double)icon.func_94210_h());
    }

    private static void drawXNeg(Tessellator tessellator, double minY, double maxY, double minZ, double maxZ, double x, IIcon icon) {
        tessellator.func_78374_a(x, maxY, maxZ, (double)icon.func_94212_f(), (double)icon.func_94206_g());
        tessellator.func_78374_a(x, maxY, minZ, (double)icon.func_94209_e(), (double)icon.func_94206_g());
        tessellator.func_78374_a(x, minY, minZ, (double)icon.func_94209_e(), (double)icon.func_94210_h());
        tessellator.func_78374_a(x, minY, maxZ, (double)icon.func_94212_f(), (double)icon.func_94210_h());
    }

    private static void drawYPos(Tessellator tessellator, double minX, double maxX, double minZ, double maxZ, double y, IIcon icon) {
        tessellator.func_78374_a(minX, y, maxZ, (double)icon.func_94212_f(), (double)icon.func_94206_g());
        tessellator.func_78374_a(maxX, y, maxZ, (double)icon.func_94209_e(), (double)icon.func_94206_g());
        tessellator.func_78374_a(maxX, y, minZ, (double)icon.func_94209_e(), (double)icon.func_94210_h());
        tessellator.func_78374_a(minX, y, minZ, (double)icon.func_94212_f(), (double)icon.func_94210_h());
    }

    private static void drawYNeg(Tessellator tessellator, double minX, double maxX, double minZ, double maxZ, double y, IIcon icon) {
        tessellator.func_78374_a(maxX, y, maxZ, (double)icon.func_94212_f(), (double)icon.func_94206_g());
        tessellator.func_78374_a(minX, y, maxZ, (double)icon.func_94209_e(), (double)icon.func_94206_g());
        tessellator.func_78374_a(minX, y, minZ, (double)icon.func_94209_e(), (double)icon.func_94210_h());
        tessellator.func_78374_a(maxX, y, minZ, (double)icon.func_94212_f(), (double)icon.func_94210_h());
    }

    private static void drawZPos(Tessellator tessellator, double minX, double maxX, double minY, double maxY, double z, IIcon icon) {
        tessellator.func_78374_a(maxX, maxY, z, (double)icon.func_94212_f(), (double)icon.func_94206_g());
        tessellator.func_78374_a(minX, maxY, z, (double)icon.func_94209_e(), (double)icon.func_94206_g());
        tessellator.func_78374_a(minX, minY, z, (double)icon.func_94209_e(), (double)icon.func_94210_h());
        tessellator.func_78374_a(maxX, minY, z, (double)icon.func_94212_f(), (double)icon.func_94210_h());
    }

    private static void drawZNeg(Tessellator tessellator, double minX, double maxX, double minY, double maxY, double z, IIcon icon) {
        tessellator.func_78374_a(minX, maxY, z, (double)icon.func_94212_f(), (double)icon.func_94206_g());
        tessellator.func_78374_a(maxX, maxY, z, (double)icon.func_94209_e(), (double)icon.func_94206_g());
        tessellator.func_78374_a(maxX, minY, z, (double)icon.func_94209_e(), (double)icon.func_94210_h());
        tessellator.func_78374_a(minX, minY, z, (double)icon.func_94212_f(), (double)icon.func_94210_h());
    }

    private static class SegmentBuffer {
        private static final float[] DefaultCenter = new float[]{0.05f, -0.05f, 0.95f, 1.05f};
        private static final float[] DefaultXMin = new float[]{-0.05f, -0.05f, 0.05f, 1.05f};
        private static final float[] DefaultXMax = new float[]{0.95f, -0.05f, 1.05f, 1.05f};
        public final float[] center = new float[4];
        public final float[] xMin = new float[4];
        public final float[] xMax = new float[4];
        public final float[][] result = new float[3][];

        private SegmentBuffer() {
        }

        public void init() {
            System.arraycopy(DefaultCenter, 0, this.center, 0, 4);
            System.arraycopy(DefaultXMin, 0, this.xMin, 0, 4);
            System.arraycopy(DefaultXMax, 0, this.xMax, 0, 4);
        }
    }

    private static interface Sampler {
        public boolean sample(int var1, int var2, int var3, int var4);
    }
}

