/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.rple.internal.client.lightmap;

import com.falsepattern.rple.internal.Compat;
import com.falsepattern.rple.internal.client.lightmap.LightMap;
import com.falsepattern.rple.internal.common.config.RPLEConfig;
import net.minecraft.client.renderer.OpenGlHelper;
import org.lwjgl.opengl.GL11;

public class LightMapStateMachine {
    private static final int STATE_WAITING = 1;
    private static final int STATE_LIGHTMAP_BOUND = 2;
    private static final int STATE_TEXTURE_TOGGLED = 3;
    private static int currentState = 1;
    private static boolean isEnabled;

    public static void enableTex() {
        if (currentState != 2) {
            currentState = 1;
            return;
        }
        isEnabled = true;
        currentState = 3;
    }

    public static void disableTex() {
        if (currentState != 2) {
            currentState = 1;
            return;
        }
        isEnabled = false;
        currentState = 3;
    }

    public static void setActiveTexture(int texture) {
        if (RPLEConfig.Compat.FASTER_GL_STATE_TRACKING) {
            LightMapStateMachine.setActiveTextureFast(texture);
        } else {
            LightMapStateMachine.setActiveTextureSafe(texture);
        }
    }

    private static void setActiveTextureFast(int texture) {
        boolean shadersEnabled = Compat.shadersEnabled();
        switch (currentState) {
            case 1: {
                if (texture != OpenGlHelper.field_77476_b) break;
                currentState = 2;
                break;
            }
            case 3: {
                if (texture != OpenGlHelper.field_77476_b) {
                    if (isEnabled || !shadersEnabled) {
                        GL11.glEnable((int)3553);
                    } else {
                        GL11.glDisable((int)3553);
                    }
                    LightMap.lightMap().toggleEnabled(isEnabled);
                }
                currentState = 1;
            }
        }
        if (shadersEnabled) {
            Compat.optiFineSetActiveTexture(texture);
        }
    }

    private static void setActiveTextureSafe(int texture) {
        boolean shadersEnabled = Compat.shadersEnabled();
        int lastTexture = GL11.glGetInteger((int)34016);
        if (lastTexture == OpenGlHelper.field_77476_b && texture != OpenGlHelper.field_77476_b) {
            boolean isTexture2DEnabled = GL11.glGetBoolean((int)3553);
            if (isTexture2DEnabled || !shadersEnabled) {
                GL11.glEnable((int)3553);
            } else {
                GL11.glDisable((int)3553);
            }
            LightMap.lightMap().toggleEnabled(isTexture2DEnabled);
        }
        if (shadersEnabled) {
            Compat.optiFineSetActiveTexture(texture);
        }
    }
}

