/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.rple.internal.common.chunk;

import com.falsepattern.chunk.api.ArrayUtil;
import com.falsepattern.lumi.api.chunk.LumiSubChunk;
import com.falsepattern.lumi.api.lighting.LightType;
import com.falsepattern.rple.api.common.color.ColorChannel;
import com.falsepattern.rple.internal.ArrayHelper;
import com.falsepattern.rple.internal.common.chunk.RPLESubChunk;
import com.falsepattern.rple.internal.common.chunk.RPLESubChunkRoot;
import java.nio.ByteBuffer;
import lombok.Generated;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.chunk.NibbleArray;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RPLESubChunkContainer
implements RPLESubChunk {
    private static final String RED_SUB_CHUNK_ID = "rple_" + (Object)((Object)ColorChannel.RED_CHANNEL) + "_sub_chunk";
    private static final String GREEN_SUB_CHUNK_ID = "rple_" + (Object)((Object)ColorChannel.GREEN_CHANNEL) + "_sub_chunk";
    private static final String BLUE_SUB_CHUNK_ID = "rple_" + (Object)((Object)ColorChannel.BLUE_CHANNEL) + "_sub_chunk";
    private final ColorChannel channel;
    private final RPLESubChunkRoot root;
    @Nullable
    private NibbleArray blockLight;
    @Nullable
    private NibbleArray skyLight;

    public RPLESubChunkContainer(ColorChannel channel, RPLESubChunkRoot root, boolean hasSky) {
        this.channel = channel;
        this.root = root;
    }

    @Override
    @NotNull
    public ColorChannel rple$channel() {
        return this.channel;
    }

    @Override
    @NotNull
    public RPLESubChunkRoot lumi$root() {
        return this.root;
    }

    @NotNull
    public String lumi$subChunkID() {
        switch (this.channel) {
            default: {
                return RED_SUB_CHUNK_ID;
            }
            case GREEN_CHANNEL: {
                return GREEN_SUB_CHUNK_ID;
            }
            case BLUE_CHANNEL: 
        }
        return BLUE_SUB_CHUNK_ID;
    }

    public void lumi$writeToNBT(@NotNull NBTTagCompound output) {
        if (this.blockLight != null) {
            output.func_74773_a("block_light", this.blockLight.field_76585_a);
        }
        if (this.skyLight != null) {
            output.func_74773_a("sky_light", this.skyLight.field_76585_a);
        }
    }

    public void lumi$readFromNBT(@NotNull NBTTagCompound input) {
        if (input.func_150297_b("block_light", 7)) {
            byte[] blockLightBytes = input.func_74770_j("block_light");
            if (ArrayHelper.isZero(blockLightBytes)) {
                this.blockLight = null;
            } else if (this.blockLight == null) {
                this.blockLight = new NibbleArray(blockLightBytes, 4);
            } else {
                System.arraycopy(blockLightBytes, 0, this.blockLight.field_76585_a, 0, 2048);
            }
        } else {
            this.blockLight = null;
        }
        if (input.func_150297_b("sky_light", 7)) {
            byte[] skyLightBytes = input.func_74770_j("sky_light");
            if (ArrayHelper.isZero(skyLightBytes)) {
                this.skyLight = null;
            } else if (this.skyLight == null) {
                this.skyLight = new NibbleArray(skyLightBytes, 4);
            } else {
                System.arraycopy(skyLightBytes, 0, this.skyLight.field_76585_a, 0, 2048);
            }
        } else {
            this.skyLight = null;
        }
    }

    public void lumi$cloneFrom(LumiSubChunk from) {
        this.blockLight = ArrayUtil.copyArray((NibbleArray)from.lumi$getBlockLightArray(), (NibbleArray)this.lumi$getBlockLightArray());
        this.skyLight = ArrayUtil.copyArray((NibbleArray)from.lumi$getSkyLightArray(), (NibbleArray)this.lumi$getSkyLightArray());
    }

    public void lumi$writeToPacket(@NotNull ByteBuffer output) {
        if (this.blockLight != null && ArrayHelper.isZero(this.blockLight.field_76585_a)) {
            this.blockLight = null;
        }
        if (this.skyLight != null && ArrayHelper.isZero(this.skyLight.field_76585_a)) {
            this.skyLight = null;
        }
        byte flag = (byte)((this.blockLight != null ? 1 : 0) | (this.skyLight != null ? 2 : 0));
        output.put(flag);
        if (this.blockLight != null) {
            output.put(this.blockLight.field_76585_a);
        }
        if (this.skyLight != null) {
            output.put(this.skyLight.field_76585_a);
        }
    }

    public void lumi$readFromPacket(@NotNull ByteBuffer input) {
        boolean doSky;
        byte flag = input.get();
        boolean doBlock = (flag & 1) != 0;
        boolean bl = doSky = (flag & 2) != 0;
        if (doBlock) {
            if (this.blockLight == null) {
                this.blockLight = new NibbleArray(4096, 4);
            }
            input.get(this.blockLight.field_76585_a);
        } else {
            this.blockLight = null;
        }
        if (doSky) {
            if (this.skyLight == null) {
                this.skyLight = new NibbleArray(4096, 4);
            }
            input.get(this.skyLight.field_76585_a);
        } else {
            this.skyLight = null;
        }
    }

    public void lumi$setLightValue(@NotNull LightType lightType, int subChunkPosX, int subChunkPosY, int subChunkPosZ, int lightValue) {
        switch (lightType) {
            case BLOCK_LIGHT_TYPE: {
                this.lumi$setBlockLightValue(subChunkPosX, subChunkPosY, subChunkPosZ, lightValue);
                break;
            }
            case SKY_LIGHT_TYPE: {
                this.lumi$setSkyLightValue(subChunkPosX, subChunkPosY, subChunkPosZ, lightValue);
                break;
            }
        }
    }

    public int lumi$getLightValue(@NotNull LightType lightType, int subChunkPosX, int subChunkPosY, int subChunkPosZ) {
        switch (lightType) {
            case BLOCK_LIGHT_TYPE: {
                return this.lumi$getBlockLightValue(subChunkPosX, subChunkPosY, subChunkPosZ);
            }
            case SKY_LIGHT_TYPE: {
                return this.lumi$getSkyLightValue(subChunkPosX, subChunkPosY, subChunkPosZ);
            }
        }
        return lightType.defaultLightValue();
    }

    public void lumi$setBlockLightValue(int subChunkPosX, int subChunkPosY, int subChunkPosZ, int lightValue) {
        if (this.blockLight == null) {
            if (lightValue == 0) {
                return;
            }
            this.blockLight = new NibbleArray(4096, 4);
        }
        this.blockLight.func_76581_a(subChunkPosX, subChunkPosY, subChunkPosZ, lightValue);
    }

    public int lumi$getBlockLightValue(int subChunkPosX, int subChunkPosY, int subChunkPosZ) {
        if (this.blockLight == null) {
            return 0;
        }
        return this.blockLight.func_76582_a(subChunkPosX, subChunkPosY, subChunkPosZ);
    }

    public void lumi$setSkyLightValue(int subChunkPosX, int subChunkPosY, int subChunkPosZ, int lightValue) {
        if (this.skyLight == null) {
            if (lightValue == 0) {
                return;
            }
            this.skyLight = new NibbleArray(4096, 4);
        }
        this.skyLight.func_76581_a(subChunkPosX, subChunkPosY, subChunkPosZ, lightValue);
    }

    public int lumi$getSkyLightValue(int subChunkPosX, int subChunkPosY, int subChunkPosZ) {
        if (this.skyLight == null) {
            return 0;
        }
        return this.skyLight.func_76582_a(subChunkPosX, subChunkPosY, subChunkPosZ);
    }

    public NibbleArray lumi$getBlockLightArray() {
        return this.blockLight;
    }

    public NibbleArray lumi$getSkyLightArray() {
        return this.skyLight;
    }

    @Generated
    public ColorChannel channel() {
        return this.channel;
    }

    @Generated
    public RPLESubChunkRoot root() {
        return this.root;
    }

    @Nullable
    @Generated
    public NibbleArray blockLight() {
        return this.blockLight;
    }

    @Nullable
    @Generated
    public NibbleArray skyLight() {
        return this.skyLight;
    }
}

