/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.rple.internal.common.config.adapter;

import com.falsepattern.rple.internal.common.config.ColorConfigLoader;
import com.falsepattern.rple.internal.common.config.container.ColorReference;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import lombok.Generated;

public final class ColorReferenceJSONAdapter
extends TypeAdapter<ColorReference> {
    public void write(JsonWriter out, ColorReference value) {
        ColorConfigLoader.colorConfigGSON().toJson((Object)value.toString(), String.class, out);
    }

    public ColorReference read(JsonReader in) {
        String color;
        try {
            color = (String)ColorConfigLoader.colorConfigGSON().fromJson(in, String.class);
        }
        catch (JsonSyntaxException e) {
            ColorConfigLoader.logParsingError("Failed parsing color reference: {}", e.getMessage());
            return ColorReference.INVALID_COLOR_REFERENCE;
        }
        ColorReference colorReference = new ColorReference(color);
        if (!colorReference.isValid()) {
            ColorConfigLoader.logParsingError("Invalid color reference: {}", color);
            return ColorReference.INVALID_COLOR_REFERENCE;
        }
        return colorReference;
    }

    @Generated
    public ColorReferenceJSONAdapter() {
    }
}

