/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.rple.internal.common.config.container;

import com.falsepattern.rple.api.common.color.RPLENamedColor;
import com.falsepattern.rple.internal.common.config.container.BlockReference;
import com.falsepattern.rple.internal.common.config.container.ColorPalette;
import com.falsepattern.rple.internal.common.config.container.ColorReference;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.annotations.UnmodifiableView;

public final class BlockColorConfig {
    private final ColorPalette palette;
    private final LinkedHashMap<BlockReference, ColorReference> brightness;
    private final LinkedHashMap<BlockReference, ColorReference> translucency;

    public BlockColorConfig() {
        this.palette = new ColorPalette();
        this.brightness = new LinkedHashMap();
        this.translucency = new LinkedHashMap();
    }

    public @Unmodifiable Map<BlockReference, ColorReference> brightness() {
        return Collections.unmodifiableMap(this.brightness);
    }

    public @UnmodifiableView Map<BlockReference, ColorReference> translucency() {
        return Collections.unmodifiableMap(this.translucency);
    }

    public void addPaletteColor(RPLENamedColor color) {
        this.palette.addPaletteColor(color);
    }

    public Optional<ColorReference> setBlockBrightness(BlockReference block, ColorReference color) {
        return Optional.ofNullable(this.brightness.put(block, color));
    }

    public Optional<ColorReference> setBlockTranslucency(BlockReference block, ColorReference color) {
        return Optional.ofNullable(this.translucency.put(block, color));
    }

    public int hashCode() {
        int hashCode = this.palette.hashCode();
        hashCode = 31 * hashCode + this.brightness.hashCode();
        hashCode = 31 * hashCode + this.translucency.hashCode();
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BlockColorConfig)) {
            return false;
        }
        BlockColorConfig other = (BlockColorConfig)obj;
        return this.palette.equals(other.palette) && this.brightness.equals(other.brightness) && this.translucency.equals(other.translucency);
    }

    @Generated
    public BlockColorConfig(ColorPalette palette, LinkedHashMap<BlockReference, ColorReference> brightness, LinkedHashMap<BlockReference, ColorReference> translucency) {
        this.palette = palette;
        this.brightness = brightness;
        this.translucency = translucency;
    }

    @Generated
    public ColorPalette palette() {
        return this.palette;
    }
}

