/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.rple.internal.common.config.container;

import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public final class BlockReference
implements Comparable<BlockReference> {
    public static final String INVALID_BLOCK_DOMAIN = "invalid_domain";
    public static final String INVALID_BLOCK_NAME = "invalid_name";
    public static final BlockReference INVALID_BLOCK_REFERENCE = new BlockReference("invalid_domain:invalid_name");
    private final String domain;
    private final String name;
    @Nullable
    private final Integer meta;
    private final boolean isValid;

    public BlockReference(String blockID) {
        String domain = "";
        String name = "";
        Integer meta = null;
        boolean isValid = false;
        try {
            String[] subStrings = StringUtils.splitPreserveAllTokens((String)blockID, (char)':');
            int subStringCount = subStrings.length;
            if (subStringCount < 2 || subStringCount > 3) {
                throw new IllegalArgumentException();
            }
            domain = subStrings[0];
            name = subStrings[1];
            if (subStringCount > 2) {
                meta = Integer.valueOf(subStrings[2]);
            }
            if (domain == null || domain.isEmpty()) {
                throw new IllegalArgumentException();
            }
            if (name == null || name.isEmpty()) {
                throw new IllegalArgumentException();
            }
            if (meta != null && meta < 0) {
                throw new IllegalArgumentException();
            }
            isValid = true;
        }
        catch (IllegalArgumentException e) {
            domain = INVALID_BLOCK_DOMAIN;
            name = INVALID_BLOCK_NAME;
            meta = null;
            isValid = false;
        }
        this.domain = domain;
        this.name = name;
        this.meta = meta;
        this.isValid = isValid;
    }

    public Optional<Integer> meta() {
        return Optional.ofNullable(this.meta);
    }

    @Override
    public int compareTo(BlockReference otherBlock) {
        int domainComparison = this.domain.compareTo(otherBlock.domain);
        if (domainComparison != 0) {
            return domainComparison;
        }
        int nameComparison = this.name.compareTo(otherBlock.name);
        if (nameComparison != 0) {
            return nameComparison;
        }
        if (this.meta == null && otherBlock.meta == null) {
            return 0;
        }
        if (this.meta == null) {
            return -1;
        }
        if (otherBlock.meta == null) {
            return 1;
        }
        return this.meta.compareTo(otherBlock.meta);
    }

    public int hashCode() {
        int hashCode = this.domain.hashCode();
        hashCode = 31 * hashCode + this.name.hashCode();
        if (this.meta != null) {
            hashCode = 31 * hashCode + this.meta.hashCode();
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BlockReference)) {
            return false;
        }
        BlockReference otherBlock = (BlockReference)obj;
        return this.domain.equals(otherBlock.domain) && this.name.equals(otherBlock.name) && this.meta().equals(otherBlock.meta());
    }

    public String toString() {
        if (this.meta != null) {
            return this.domain + ":" + this.name + ":" + this.meta;
        }
        return this.domain + ":" + this.name;
    }

    @Generated
    public String domain() {
        return this.domain;
    }

    @Generated
    public String name() {
        return this.name;
    }

    @Generated
    public boolean isValid() {
        return this.isValid;
    }

    @Generated
    private BlockReference(String domain, String name, @Nullable Integer meta, boolean isValid) {
        this.domain = domain;
        this.name = name;
        this.meta = meta;
        this.isValid = isValid;
    }
}

