/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.rple.internal.mixin.mixins.common.rple;

import com.falsepattern.lumi.api.chunk.LumiChunkRoot;
import com.falsepattern.rple.api.common.color.ColorChannel;
import com.falsepattern.rple.internal.common.cache.RPLEBlockStorage;
import com.falsepattern.rple.internal.common.cache.RPLEBlockStorageRoot;
import com.falsepattern.rple.internal.common.chunk.RPLEChunkRoot;
import com.falsepattern.rple.internal.common.world.RPLEWorldRoot;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Dynamic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Unique
@Mixin(value={ChunkCache.class})
public abstract class RPLEBlockCacheRootImplMixin
implements IBlockAccess,
RPLEBlockStorageRoot {
    @Shadow
    public World field_72815_e;
    private RPLEBlockStorage rple$redChannel;
    private RPLEBlockStorage rple$greenChannel;
    private RPLEBlockStorage rple$blueChannel;

    @Inject(method={"lumi$onChunkCacheInit()V"}, at={@At(value="RETURN")}, remap=false, require=1)
    @Dynamic(value="Implemented by [Lumi] with the interface [com.falsepattern.lumi.api.init.LumiChunkCacheInitHook]")
    private void rpleBlockCacheRootInit(CallbackInfo ci) {
        if (this.field_72815_e == null) {
            return;
        }
        RPLEWorldRoot worldRoot = (RPLEWorldRoot)this.field_72815_e;
        this.rple$redChannel = worldRoot.rple$world(ColorChannel.RED_CHANNEL).getCloneForChunkCache(this);
        this.rple$greenChannel = worldRoot.rple$world(ColorChannel.GREEN_CHANNEL).getCloneForChunkCache(this);
        this.rple$blueChannel = worldRoot.rple$world(ColorChannel.BLUE_CHANNEL).getCloneForChunkCache(this);
    }

    @Override
    @NotNull
    public RPLEBlockStorage rple$blockStorage(@NotNull ColorChannel channel) {
        switch (channel) {
            default: {
                return this.rple$redChannel;
            }
            case GREEN_CHANNEL: {
                return this.rple$greenChannel;
            }
            case BLUE_CHANNEL: 
        }
        return this.rple$blueChannel;
    }

    @Override
    @Nullable
    public RPLEChunkRoot rple$getChunkRootFromBlockPosIfExists(int posX, int posZ) {
        LumiChunkRoot chunk = this.lumi$getChunkRootFromBlockPosIfExists(posX, posZ);
        if (chunk instanceof RPLEChunkRoot) {
            return (RPLEChunkRoot)chunk;
        }
        return null;
    }

    @Override
    @Nullable
    public RPLEChunkRoot rple$getChunkRootFromChunkPosIfExists(int chunkPosX, int chunkPosZ) {
        LumiChunkRoot chunk = this.lumi$getChunkRootFromChunkPosIfExists(chunkPosX, chunkPosZ);
        if (chunk instanceof RPLEChunkRoot) {
            return (RPLEChunkRoot)chunk;
        }
        return null;
    }

    private ChunkCache thiz() {
        return (ChunkCache)this;
    }
}

