/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.rple.internal.mixin.mixins.common.rple;

import com.falsepattern.rple.api.common.ServerColorHelper;
import com.falsepattern.rple.api.common.block.RPLEBlock;
import com.falsepattern.rple.api.common.block.RPLEBlockRoot;
import com.falsepattern.rple.api.common.block.RPLECustomBlockBrightness;
import com.falsepattern.rple.api.common.block.RPLECustomBlockTranslucency;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Dynamic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Unique
@Mixin(value={Block.class})
public abstract class RPLEBlockImplMixin
implements RPLEBlock,
RPLEBlockRoot {
    @Dynamic(value="Initialized in: [com.falsepattern.rple.internal.mixin.mixins.common.rple.RPLEBlockInitImplMixin]")
    private short rple$rawBaseBrightnessColor;
    @Dynamic(value="Initialized in: [com.falsepattern.rple.internal.mixin.mixins.common.rple.RPLEBlockInitImplMixin]")
    private short rple$rawBaseOpacityColor;
    @Dynamic(value="Initialized in: [com.falsepattern.rple.internal.mixin.mixins.common.rple.RPLEBlockInitImplMixin]")
    private short @Nullable [] rple$rawMetaBrightnessColors;
    @Dynamic(value="Initialized in: [com.falsepattern.rple.internal.mixin.mixins.common.rple.RPLEBlockInitImplMixin]")
    private short @Nullable [] rple$rawMetaOpacityColors;

    @Shadow(remap=false)
    public abstract boolean hasTileEntity(int var1);

    @Override
    public short rple$getRawBrightnessColor() {
        if (this instanceof RPLECustomBlockBrightness) {
            RPLECustomBlockBrightness colorProvider = (RPLECustomBlockBrightness)((Object)this);
            try {
                return colorProvider.rple$getCustomBrightnessColor();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.rple$rawBaseBrightnessColor != -1) {
            return this.rple$rawBaseBrightnessColor;
        }
        return this.rple$getRawInternalColoredBrightness();
    }

    @Override
    public short rple$getRawBrightnessColor(int blockMeta) {
        short brightness;
        if (this instanceof RPLECustomBlockBrightness) {
            RPLECustomBlockBrightness colorProvider = (RPLECustomBlockBrightness)((Object)this);
            try {
                return colorProvider.rple$getCustomBrightnessColor(blockMeta);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.rple$rawMetaBrightnessColors != null && blockMeta >= 0 && blockMeta < this.rple$rawMetaBrightnessColors.length && (brightness = this.rple$rawMetaBrightnessColors[blockMeta]) != -1) {
            return brightness;
        }
        if (this.rple$rawBaseBrightnessColor != -1) {
            return this.rple$rawBaseBrightnessColor;
        }
        return this.rple$getRawInternalColoredBrightness();
    }

    @Override
    public short rple$getRawBrightnessColor(@NotNull IBlockAccess world, int blockMeta, int posX, int posY, int posZ) {
        short brightness;
        TileEntity tileEntity;
        if (this instanceof RPLECustomBlockBrightness) {
            RPLECustomBlockBrightness colorProvider = (RPLECustomBlockBrightness)((Object)this);
            try {
                return colorProvider.rple$getCustomBrightnessColor(world, blockMeta, posX, posY, posZ);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.hasTileEntity(blockMeta) && (tileEntity = world.func_147438_o(posX, posY, posZ)) instanceof RPLECustomBlockBrightness) {
            RPLECustomBlockBrightness colorProvider = (RPLECustomBlockBrightness)tileEntity;
            try {
                return colorProvider.rple$getCustomBrightnessColor(world, blockMeta, posX, posY, posZ);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.rple$rawMetaBrightnessColors != null && blockMeta >= 0 && blockMeta < this.rple$rawMetaBrightnessColors.length && (brightness = this.rple$rawMetaBrightnessColors[blockMeta]) != -1) {
            return brightness;
        }
        if (this.rple$rawBaseBrightnessColor != -1) {
            return this.rple$rawBaseBrightnessColor;
        }
        return this.rple$getRawInternalColoredBrightness(world, posX, posY, posZ);
    }

    @Override
    public short rple$getRawOpacityColor() {
        if (this instanceof RPLECustomBlockTranslucency) {
            RPLECustomBlockTranslucency colorProvider = (RPLECustomBlockTranslucency)((Object)this);
            try {
                short color = colorProvider.rple$getCustomTranslucencyColor();
                return ServerColorHelper.RGB16OpacityTranslucentSwap(color);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.rple$rawBaseOpacityColor != -1) {
            return this.rple$rawBaseOpacityColor;
        }
        return this.rple$getRawInternalColoredOpacity();
    }

    @Override
    public short rple$getRawOpacityColor(int blockMeta) {
        short opacity;
        if (this instanceof RPLECustomBlockTranslucency) {
            RPLECustomBlockTranslucency colorProvider = (RPLECustomBlockTranslucency)((Object)this);
            try {
                short color = colorProvider.rple$getCustomTranslucencyColor(blockMeta);
                return ServerColorHelper.RGB16OpacityTranslucentSwap(color);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.rple$rawMetaOpacityColors != null && blockMeta >= 0 && blockMeta < this.rple$rawMetaOpacityColors.length && (opacity = this.rple$rawMetaOpacityColors[blockMeta]) != -1) {
            return opacity;
        }
        if (this.rple$rawBaseOpacityColor != -1) {
            return this.rple$rawBaseOpacityColor;
        }
        return this.rple$getRawInternalColoredOpacity();
    }

    @Override
    public short rple$getRawOpacityColor(@NotNull IBlockAccess world, int blockMeta, int posX, int posY, int posZ) {
        short opacity;
        TileEntity tileEntity;
        if (this instanceof RPLECustomBlockTranslucency) {
            RPLECustomBlockTranslucency colorProvider = (RPLECustomBlockTranslucency)((Object)this);
            try {
                short color = colorProvider.rple$getCustomTranslucencyColor(world, blockMeta, posX, posY, posZ);
                return ServerColorHelper.RGB16OpacityTranslucentSwap(color);
            }
            catch (Exception color) {
                // empty catch block
            }
        }
        if (this.hasTileEntity(blockMeta) && (tileEntity = world.func_147438_o(posX, posY, posZ)) instanceof RPLECustomBlockTranslucency) {
            RPLECustomBlockTranslucency colorProvider = (RPLECustomBlockTranslucency)tileEntity;
            try {
                short color = colorProvider.rple$getCustomTranslucencyColor(world, blockMeta, posX, posY, posZ);
                return ServerColorHelper.RGB16OpacityTranslucentSwap(color);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.rple$rawMetaOpacityColors != null && blockMeta >= 0 && blockMeta < this.rple$rawMetaOpacityColors.length && (opacity = this.rple$rawMetaOpacityColors[blockMeta]) != -1) {
            return opacity;
        }
        if (this.rple$rawBaseOpacityColor != -1) {
            return this.rple$rawBaseOpacityColor;
        }
        return this.rple$getRawInternalColoredOpacity(world, posX, posY, posZ);
    }

    @Override
    public short rple$getBrightnessColor() {
        if (this instanceof RPLECustomBlockBrightness) {
            RPLECustomBlockBrightness colorProvider = (RPLECustomBlockBrightness)((Object)this);
            try {
                short color = colorProvider.rple$getCustomBrightnessColor();
                if (color != -1) {
                    return color;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.rple$getFallbackBrightnessColor();
    }

    @Override
    public short rple$getBrightnessColor(int blockMeta) {
        if (this instanceof RPLECustomBlockBrightness) {
            RPLECustomBlockBrightness colorProvider = (RPLECustomBlockBrightness)((Object)this);
            try {
                short color = colorProvider.rple$getCustomBrightnessColor(blockMeta);
                if (color != -1) {
                    return color;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.rple$getFallbackBrightnessColor(blockMeta);
    }

    @Override
    public short rple$getBrightnessColor(@NotNull IBlockAccess world, int blockMeta, int posX, int posY, int posZ) {
        TileEntity tileEntity;
        if (this instanceof RPLECustomBlockBrightness) {
            RPLECustomBlockBrightness colorProvider = (RPLECustomBlockBrightness)((Object)this);
            try {
                short color = colorProvider.rple$getCustomBrightnessColor(world, blockMeta, posX, posY, posZ);
                if (color != -1) {
                    return color;
                }
            }
            catch (Exception color) {
                // empty catch block
            }
        }
        if (this.hasTileEntity(blockMeta) && (tileEntity = world.func_147438_o(posX, posY, posZ)) instanceof RPLECustomBlockBrightness) {
            RPLECustomBlockBrightness colorProvider = (RPLECustomBlockBrightness)tileEntity;
            try {
                short color = colorProvider.rple$getCustomBrightnessColor(world, blockMeta, posX, posY, posZ);
                if (color != -1) {
                    return color;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.rple$getFallbackBrightnessColor(world, blockMeta, posX, posY, posZ);
    }

    @Override
    public short rple$getTranslucencyColor() {
        if (this instanceof RPLECustomBlockTranslucency) {
            RPLECustomBlockTranslucency colorProvider = (RPLECustomBlockTranslucency)((Object)this);
            try {
                short color = colorProvider.rple$getCustomTranslucencyColor();
                if (color != -1) {
                    return color;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.rple$getFallbackTranslucencyColor();
    }

    @Override
    public short rple$getTranslucencyColor(int blockMeta) {
        if (this instanceof RPLECustomBlockTranslucency) {
            RPLECustomBlockTranslucency colorProvider = (RPLECustomBlockTranslucency)((Object)this);
            try {
                short color = colorProvider.rple$getCustomTranslucencyColor(blockMeta);
                if (color != -1) {
                    return color;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.rple$getFallbackTranslucencyColor(blockMeta);
    }

    @Override
    public short rple$getTranslucencyColor(@NotNull IBlockAccess world, int blockMeta, int posX, int posY, int posZ) {
        TileEntity tileEntity;
        if (this instanceof RPLECustomBlockTranslucency) {
            RPLECustomBlockTranslucency colorProvider = (RPLECustomBlockTranslucency)((Object)this);
            try {
                short color = colorProvider.rple$getCustomTranslucencyColor(world, blockMeta, posX, posY, posZ);
                if (color != -1) {
                    return color;
                }
            }
            catch (Exception color) {
                // empty catch block
            }
        }
        if (this.hasTileEntity(blockMeta) && (tileEntity = world.func_147438_o(posX, posY, posZ)) instanceof RPLECustomBlockTranslucency) {
            RPLECustomBlockTranslucency colorProvider = (RPLECustomBlockTranslucency)tileEntity;
            try {
                short color = colorProvider.rple$getCustomTranslucencyColor(world, blockMeta, posX, posY, posZ);
                if (color != -1) {
                    return color;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.rple$getFallbackTranslucencyColor(world, blockMeta, posX, posY, posZ);
    }

    @Override
    public short rple$getFallbackBrightnessColor() {
        short color = this.rple$getConfiguredBrightnessColor();
        if (color != -1) {
            return color;
        }
        return this.rple$getInternalColoredBrightness();
    }

    @Override
    public short rple$getFallbackBrightnessColor(int blockMeta) {
        short color = this.rple$getConfiguredBrightnessColor(blockMeta);
        if (color != -1) {
            return color;
        }
        return this.rple$getInternalColoredBrightness();
    }

    @Override
    public short rple$getFallbackBrightnessColor(@NotNull IBlockAccess world, int blockMeta, int posX, int posY, int posZ) {
        short color = this.rple$getConfiguredBrightnessColor(blockMeta);
        if (color != -1) {
            return color;
        }
        return this.rple$getInternalColoredBrightness(world, posX, posY, posZ);
    }

    @Override
    public short rple$getFallbackTranslucencyColor() {
        short color = this.rple$getConfiguredTranslucencyColor();
        if (color != -1) {
            return color;
        }
        return this.rple$getInternalColoredTranslucency();
    }

    @Override
    public short rple$getFallbackTranslucencyColor(int blockMeta) {
        short color = this.rple$getConfiguredTranslucencyColor(blockMeta);
        if (color != -1) {
            return color;
        }
        return this.rple$getInternalColoredTranslucency();
    }

    @Override
    public short rple$getFallbackTranslucencyColor(@NotNull IBlockAccess world, int blockMeta, int posX, int posY, int posZ) {
        short color = this.rple$getConfiguredTranslucencyColor(blockMeta);
        if (color != -1) {
            return color;
        }
        return this.rple$getInternalColoredTranslucency(world, posX, posY, posZ);
    }

    @Override
    public short rple$getConfiguredBrightnessColor() {
        if (this.rple$rawBaseBrightnessColor != -1) {
            return this.rple$rawBaseBrightnessColor;
        }
        if (this.rple$rawMetaBrightnessColors == null) {
            return -1;
        }
        if (this.rple$rawMetaBrightnessColors.length < 1) {
            return -1;
        }
        return this.rple$rawMetaBrightnessColors[0];
    }

    @Override
    public short rple$getConfiguredBrightnessColor(int blockMeta) {
        if (this.rple$rawMetaBrightnessColors == null) {
            return this.rple$rawBaseBrightnessColor;
        }
        if (this.rple$rawMetaBrightnessColors.length <= blockMeta) {
            return this.rple$rawBaseBrightnessColor;
        }
        return this.rple$rawMetaBrightnessColors[blockMeta];
    }

    @Override
    public short rple$getConfiguredTranslucencyColor() {
        if (this.rple$rawBaseOpacityColor != -1) {
            return ServerColorHelper.RGB16OpacityTranslucentSwap(this.rple$rawBaseOpacityColor);
        }
        if (this.rple$rawMetaOpacityColors == null) {
            return -1;
        }
        if (this.rple$rawMetaOpacityColors.length < 1) {
            return -1;
        }
        return ServerColorHelper.RGB16OpacityTranslucentSwap(this.rple$rawMetaOpacityColors[0]);
    }

    @Override
    public short rple$getConfiguredTranslucencyColor(int blockMeta) {
        if (this.rple$rawMetaOpacityColors == null) {
            return ServerColorHelper.RGB16OpacityTranslucentSwap(this.rple$rawBaseOpacityColor);
        }
        if (this.rple$rawMetaOpacityColors.length <= blockMeta) {
            return ServerColorHelper.RGB16OpacityTranslucentSwap(this.rple$rawBaseOpacityColor);
        }
        return ServerColorHelper.RGB16OpacityTranslucentSwap(this.rple$rawMetaOpacityColors[blockMeta]);
    }
}

