/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.rple.internal.mixin.mixins.common.rple;

import com.falsepattern.rple.api.common.ServerColorHelper;
import com.falsepattern.rple.internal.common.block.RPLEBlockInit;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Unique
@Mixin(value={Block.class}, priority=980)
public abstract class RPLEBlockInitImplMixin
implements RPLEBlockInit {
    @Unique
    private short rple$rawBaseBrightnessColor;
    @Unique
    private short rple$rawBaseOpacityColor;
    @Unique
    private short @Nullable [] rple$rawMetaBrightnessColors;
    @Unique
    private short @Nullable [] rple$rawMetaOpacityColors;

    @Inject(method={"<init>"}, at={@At(value="RETURN")}, require=1)
    private void rpleBlockInit(Material material, CallbackInfo ci) {
        this.rple$rawBaseBrightnessColor = (short)-1;
        this.rple$rawBaseOpacityColor = (short)-1;
        this.rple$rawMetaBrightnessColors = null;
        this.rple$rawMetaOpacityColors = null;
    }

    @Override
    public void rple$initBaseBrightnessColor(short baseColoredBrightness) {
        this.rple$rawBaseBrightnessColor = baseColoredBrightness;
    }

    @Override
    public void rple$initBaseTranslucencyColor(short baseColoredTranslucency) {
        this.rple$rawBaseOpacityColor = baseColoredTranslucency != -1 ? ServerColorHelper.RGB16OpacityTranslucentSwap(baseColoredTranslucency) : (short)-1;
    }

    @Override
    public void rple$initMetaBrightnessColors(short @Nullable [] metaColoredBrightness) {
        if (metaColoredBrightness == null) {
            this.rple$rawMetaBrightnessColors = null;
        } else {
            this.rple$rawMetaBrightnessColors = new short[metaColoredBrightness.length];
            System.arraycopy(metaColoredBrightness, 0, this.rple$rawMetaBrightnessColors, 0, metaColoredBrightness.length);
        }
    }

    @Override
    public void rple$initMetaTranslucencyColors(short @Nullable [] metaColoredTranslucency) {
        if (metaColoredTranslucency == null) {
            this.rple$rawMetaOpacityColors = null;
        } else {
            this.rple$rawMetaOpacityColors = new short[metaColoredTranslucency.length];
            for (int i = 0; i < metaColoredTranslucency.length; ++i) {
                short op = metaColoredTranslucency[i];
                this.rple$rawMetaOpacityColors[i] = op == -1 ? -1 : ServerColorHelper.RGB16OpacityTranslucentSwap(op);
            }
        }
    }

    @Override
    public void rple$finishColorInit() {
    }
}

