/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.rple.internal.asm;

import com.falsepattern.rple.internal.asm.util.MethodDecl;
import com.falsepattern.rple.internal.asm.util.Util;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public final class RPLEBlockColorInjector
implements IClassTransformer {
    private static final String NAME_LIGHT_VALUE_DEOBF = "getLightValue";
    private static final String NAME_LIGHT_VALUE_OBF = "func_149750_m";
    private static final String NAME_LIGHT_OPACITY_DEOBF = "getLightOpacity";
    private static final String NAME_LIGHT_OPACITY_OBF = "func_149717_k";
    private static final String DESC_LIGHT_RAW = "()I";
    private static final String DESC_LIGHT_POSITIONAL = "(Lnet/minecraft/world/IBlockAccess;III)I";
    private static final String NAME_LIGHT_VALUE_RENAMED = "rple$renamed$getLightValue";
    private static final String NAME_LIGHT_OPACITY_RENAMED = "rple$renamed$getLightOpacity";
    private static final MethodDecl DECL_LIGHT_VALUE_RAW_OBF = new MethodDecl("func_149750_m", "()I");
    private static final MethodDecl DECL_LIGHT_VALUE_RAW_DEOBF = new MethodDecl("getLightValue", "()I");
    private static final MethodDecl DECL_LIGHT_VALUE_POSITIONAL = new MethodDecl("getLightValue", "(Lnet/minecraft/world/IBlockAccess;III)I");
    private static final MethodDecl DECL_LIGHT_OPACITY_RAW_OBF = new MethodDecl("func_149717_k", "()I");
    private static final MethodDecl DECL_LIGHT_OPACITY_RAW_DEOBF = new MethodDecl("getLightOpacity", "()I");
    private static final MethodDecl DECL_LIGHT_OPACITY_POSITIONAL = new MethodDecl("getLightOpacity", "(Lnet/minecraft/world/IBlockAccess;III)I");
    private static final MethodDecl[] POTENTIAL_CANDIDATES = new MethodDecl[]{DECL_LIGHT_VALUE_RAW_OBF, DECL_LIGHT_VALUE_RAW_DEOBF, DECL_LIGHT_VALUE_POSITIONAL, DECL_LIGHT_OPACITY_RAW_OBF, DECL_LIGHT_OPACITY_RAW_DEOBF, DECL_LIGHT_OPACITY_POSITIONAL};
    private static final int POTENTIAL_CANDIDATE_COUNT = POTENTIAL_CANDIDATES.length;
    private static final Logger LOG = LogManager.getLogger((String)"RPLE Block Color Injector");
    private static final Map<MethodDecl, String> MAPPINGS = new HashMap<MethodDecl, String>();
    private static final String INTERNAL_BLOCK = "net/minecraft/block/Block";
    private static final String BLOCK = "net.minecraft.block.Block";
    private static final Map<String, Boolean> BLOCK_SUBCLASS_MEMOIZATION;

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (basicClass == null || transformedName.startsWith("com.falsepattern.rple") || transformedName.equals(BLOCK)) {
            return basicClass;
        }
        if (!RPLEBlockColorInjector.isBlockSubclass(transformedName.replace('.', '/'))) {
            return basicClass;
        }
        ClassNode cn = new ClassNode();
        new ClassReader(basicClass).accept((ClassVisitor)cn, 0);
        if (!RPLEBlockColorInjector.isValidTarget(cn)) {
            return basicClass;
        }
        boolean modified = false;
        int methodCount = cn.methods.size();
        block0: for (int i = 0; i < methodCount; ++i) {
            MethodNode method = (MethodNode)cn.methods.get(i);
            for (Map.Entry<MethodDecl, String> mapping : MAPPINGS.entrySet()) {
                if (!RPLEBlockColorInjector.tryTransform(cn, method, mapping.getKey(), mapping.getValue())) continue;
                modified = true;
                continue block0;
            }
        }
        if (modified) {
            ClassWriter writer = new ClassWriter(0);
            cn.accept((ClassVisitor)writer);
            return writer.toByteArray();
        }
        return basicClass;
    }

    private static boolean tryTransform(ClassNode cn, MethodNode method, MethodDecl decl, String newName) {
        if (!decl.matches(method)) {
            return false;
        }
        method.name = newName;
        block0: for (AbstractInsnNode inst : method.instructions) {
            if (!(inst instanceof MethodInsnNode)) continue;
            MethodInsnNode insnNode = (MethodInsnNode)inst;
            if (!insnNode.owner.equals(cn.name) && !insnNode.owner.equals(cn.superName) && !RPLEBlockColorInjector.isBlockSubclass(insnNode.owner)) continue;
            for (Map.Entry<MethodDecl, String> mapping : MAPPINGS.entrySet()) {
                if (!mapping.getKey().matches(insnNode)) continue;
                insnNode.name = mapping.getValue();
                continue block0;
            }
        }
        return true;
    }

    private static boolean isBlockSubclass(String className) {
        if (className == null) {
            return false;
        }
        Boolean v = BLOCK_SUBCLASS_MEMOIZATION.get(className);
        if (v != null) {
            return v;
        }
        if (className.equals(INTERNAL_BLOCK)) {
            BLOCK_SUBCLASS_MEMOIZATION.put(className, true);
            return true;
        }
        byte[] classBytes = Util.bytesFromInternalName(className);
        if (classBytes == null) {
            BLOCK_SUBCLASS_MEMOIZATION.put(className, false);
            return false;
        }
        boolean isc = RPLEBlockColorInjector.isBlockSubclass(new ClassReader(classBytes).getSuperName());
        BLOCK_SUBCLASS_MEMOIZATION.put(className, isc);
        return isc;
    }

    private static boolean isValidTarget(ClassNode cn) {
        int methodCount = cn.methods.size();
        for (int i = 0; i < methodCount; ++i) {
            MethodNode method = (MethodNode)cn.methods.get(i);
            for (int j = 0; j < POTENTIAL_CANDIDATE_COUNT; ++j) {
                if (!POTENTIAL_CANDIDATES[j].matches(method)) continue;
                return true;
            }
        }
        return false;
    }

    static {
        MAPPINGS.put(DECL_LIGHT_VALUE_RAW_OBF, NAME_LIGHT_VALUE_RENAMED);
        MAPPINGS.put(DECL_LIGHT_VALUE_RAW_DEOBF, NAME_LIGHT_VALUE_RENAMED);
        MAPPINGS.put(DECL_LIGHT_VALUE_POSITIONAL, NAME_LIGHT_VALUE_RENAMED);
        MAPPINGS.put(DECL_LIGHT_OPACITY_RAW_OBF, NAME_LIGHT_OPACITY_RENAMED);
        MAPPINGS.put(DECL_LIGHT_OPACITY_RAW_DEOBF, NAME_LIGHT_OPACITY_RENAMED);
        MAPPINGS.put(DECL_LIGHT_OPACITY_POSITIONAL, NAME_LIGHT_OPACITY_RENAMED);
        BLOCK_SUBCLASS_MEMOIZATION = new HashMap<String, Boolean>(1024, 0.2f);
        BLOCK_SUBCLASS_MEMOIZATION.put(INTERNAL_BLOCK, true);
    }
}

