/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.rple.internal.client.dynlights;

import com.falsepattern.falsetweaks.api.dynlights.FTDynamicLights;
import com.falsepattern.rple.api.common.ServerColorHelper;
import com.falsepattern.rple.api.common.color.LightValueColor;
import com.falsepattern.rple.internal.Compat;
import com.falsepattern.rple.internal.client.dynlights.ColorDynamicLights;
import lombok.Generated;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;

public class ColorDynamicLight {
    private final Entity entity;
    private final double offsetY;
    private double lastPosX = -2.147483648E9;
    private double lastPosY = -2.147483648E9;
    private double lastPosZ = -2.147483648E9;
    private short lastLightLevel = LightValueColor.LIGHT_VALUE_0.rgb16();
    private boolean underwater = false;
    private long timeCheckMs = 0L;

    public ColorDynamicLight(Entity entity) {
        this.entity = entity;
        this.offsetY = entity.func_70047_e();
    }

    public void update(RenderGlobal renderGlobal) {
        boolean isHandLight;
        boolean bl = isHandLight = this.entity == Minecraft.func_71410_x().field_71451_h && Compat.neodymiumActive() && !Compat.shadersEnabled();
        if (!isHandLight && FTDynamicLights.isDynamicLightsFast()) {
            long timeNowMs = System.currentTimeMillis();
            if (timeNowMs < this.timeCheckMs + 500L) {
                return;
            }
            this.timeCheckMs = timeNowMs;
        }
        double posX = this.entity.field_70165_t - 0.5;
        double posY = this.entity.field_70163_u - 0.5 + this.offsetY;
        double posZ = this.entity.field_70161_v - 0.5;
        short lightLevel = ColorDynamicLights.INSTANCE.getLightLevel(this.entity);
        double dx = posX - this.lastPosX;
        double dy = posY - this.lastPosY;
        double dz = posZ - this.lastPosZ;
        double delta = 0.1;
        if (!(Math.abs(dx) <= delta && Math.abs(dy) <= delta && Math.abs(dz) <= delta && this.lastLightLevel == lightLevel)) {
            this.underwater = false;
            WorldClient world = renderGlobal.field_72769_h;
            if (world != null) {
                Block block = world.func_147439_a(MathHelper.func_76128_c((double)posX), MathHelper.func_76128_c((double)posY), MathHelper.func_76128_c((double)posZ));
                boolean bl2 = this.underwater = block == Blocks.field_150355_j;
            }
            if (!isHandLight) {
                if (lightLevel != LightValueColor.LIGHT_VALUE_0.rgb16()) {
                    int distance = ServerColorHelper.maxColorComponent(lightLevel) + 1;
                    renderGlobal.func_147585_a((int)(posX - (double)distance), (int)(posY - (double)distance), (int)(posZ - (double)distance), (int)(posX + (double)distance), (int)(posY + (double)distance), (int)(posZ + (double)distance));
                }
                this.updateLitChunks(renderGlobal);
            }
            this.lastPosX = posX;
            this.lastPosY = posY;
            this.lastPosZ = posZ;
            this.lastLightLevel = lightLevel;
        }
    }

    public void updateLitChunks(RenderGlobal renderGlobal) {
        int distance = ServerColorHelper.maxColorComponent(this.lastLightLevel) + 1;
        renderGlobal.func_147585_a((int)(this.lastPosX - (double)distance), (int)(this.lastPosY - (double)distance), (int)(this.lastPosZ - (double)distance), (int)(this.lastPosX + (double)distance), (int)(this.lastPosY + (double)distance), (int)(this.lastPosZ + (double)distance));
    }

    public String toString() {
        return "Entity: " + this.entity + ", offsetY: " + this.offsetY;
    }

    @Generated
    public Entity getEntity() {
        return this.entity;
    }

    @Generated
    public double getOffsetY() {
        return this.offsetY;
    }

    @Generated
    public double getLastPosX() {
        return this.lastPosX;
    }

    @Generated
    public double getLastPosY() {
        return this.lastPosY;
    }

    @Generated
    public double getLastPosZ() {
        return this.lastPosZ;
    }

    @Generated
    public short getLastLightLevel() {
        return this.lastLightLevel;
    }

    @Generated
    public boolean isUnderwater() {
        return this.underwater;
    }
}

