/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.rple.internal.mixin.mixins.client;

import com.falsepattern.rple.internal.client.lightmap.LightMap;
import com.falsepattern.rple.internal.client.render.LightValueOverlayRenderer;
import com.falsepattern.rple.internal.common.config.RPLEConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.util.ResourceLocation;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityRenderer.class})
public abstract class EntityRendererMixin
implements IResourceManagerReloadListener {
    @Final
    @Shadow
    private DynamicTexture field_78513_d;
    @Final
    @Shadow
    private ResourceLocation field_110922_T;
    @Final
    @Shadow
    private int[] field_78504_Q;
    @Shadow
    private boolean field_78536_aa;

    @Inject(method={"<init>"}, at={@At(value="RETURN")}, require=1)
    private void setupColorLightMaps(Minecraft minecraft, IResourceManager resourceManager, CallbackInfo ci) {
        LightMap.lightMap().generateTextures();
    }

    @Inject(method={"disableLightmap"}, at={@At(value="HEAD")}, require=1)
    private void disableLightMaps(double p_78463_1_, CallbackInfo ci) {
        LightMap.lightMap().disable();
    }

    @Inject(method={"enableLightmap"}, at={@At(value="HEAD")}, cancellable=true, require=1)
    private void enableLightMaps(double p_78463_1_, CallbackInfo ci) {
        LightMap.lightMap().enable();
        ci.cancel();
    }

    @Inject(method={"updateLightmap"}, at={@At(value="HEAD")}, cancellable=true, require=1)
    private void updateLightMap(float partialTickTime, CallbackInfo ci) {
        LightMap.lightMap().update(partialTickTime);
        this.field_78536_aa = false;
        ci.cancel();
    }

    @Inject(method={"renderWorld"}, at={@At(value="CONSTANT", args={"stringValue=destroyProgress"}, shift=At.Shift.BY, by=-3)}, require=1)
    private void renderLightValueOverlay(float partialTickTime, long expectedFrameDoneTimeNs, CallbackInfo ci) {
        if (RPLEConfig.Debug.RGB_LIGHT_OVERLAY.booleanValue()) {
            LightValueOverlayRenderer.renderLightValueOverlay();
        }
    }
}

