/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.rple.api.client.lightmap.vanilla;

import com.falsepattern.lib.util.MathUtil;
import com.falsepattern.rple.api.client.lightmap.RPLELightMapBase;
import com.falsepattern.rple.api.client.lightmap.RPLELightMapStrip;
import com.falsepattern.rple.internal.common.config.RPLEConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.world.WorldProvider;
import org.jetbrains.annotations.NotNull;

public class VanillaLightMapBase
implements RPLELightMapBase {
    protected static final int NETHER_DIMENSION_ID = -1;
    protected static final int END_DIMENSION_ID = 1;
    private static final float DARK_NETHER_REVERSAL = 1.1111112f;

    @Override
    public boolean generateBlockLightMapBase(@NotNull RPLELightMapStrip output, float partialTick) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world == null) {
            return false;
        }
        WorldProvider worldProvider = world.field_73011_w;
        if (worldProvider == null) {
            return false;
        }
        int dim = worldProvider.field_76574_g;
        boolean hd = RPLEConfig.HD.MODE != RPLEConfig.HD.Mode.Disabled;
        for (int i = 0; i < 16; ++i) {
            float brightness = worldProvider.field_76573_f[i];
            if (!hd) {
                brightness *= 0.96f;
                brightness += 0.03f;
            } else if (RPLEConfig.HD.DARK_NETHER && dim == -1) {
                brightness = (brightness - 0.1f) * 1.1111112f;
            }
            output.setLightMap(i, MathUtil.clamp((float)brightness, (float)0.0f, (float)1.0f));
        }
        return true;
    }

    @Override
    public boolean generateSkyLightMapBase(@NotNull RPLELightMapStrip output, float partialTick) {
        boolean hd;
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world == null) {
            return false;
        }
        WorldProvider worldProvider = world.field_73011_w;
        if (worldProvider == null) {
            return false;
        }
        boolean bl = hd = RPLEConfig.HD.MODE != RPLEConfig.HD.Mode.Disabled;
        if (worldProvider.field_76574_g == 1) {
            if (hd && RPLEConfig.HD.DARK_END) {
                output.fillLightMapRGB(0.0f, 0.0f, 0.0f);
            } else {
                output.fillLightMapRGB(0.22f, 0.28f, 0.25f);
            }
            return true;
        }
        if (worldProvider.field_76574_g == -1 && hd && RPLEConfig.HD.DARK_END) {
            output.fillLightMapRGB(0.0f, 0.0f, 0.0f);
            return true;
        }
        float brightness = world.func_72971_b(partialTick);
        for (int i = 0; i < 16; ++i) {
            float blue = 0.0f;
            blue = world.field_73016_r > 0 ? world.field_73011_w.field_76573_f[i] : (hd ? world.field_73011_w.field_76573_f[i] * brightness : world.field_73011_w.field_76573_f[i] * (brightness * 0.95f + 0.05f));
            float red = blue * (brightness * 0.65f + 0.35f);
            float green = blue * (brightness * 0.65f + 0.35f);
            output.setLightMapRGB(i, red, green, blue);
        }
        return true;
    }
}

