/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.rple.internal.common.collection;

public final class CircularLongBuffer {
    private final int size;
    private final long[] buffer;
    private int counter;

    public CircularLongBuffer(int size) {
        this.size = size;
        this.buffer = new long[size];
        this.counter = 0;
    }

    private int getAndIncrementIndexModular() {
        int i = this.counter;
        this.counter = (this.counter + 1) % this.size;
        return i;
    }

    public int put(long value) {
        int index = this.getAndIncrementIndexModular();
        this.buffer[index] = value;
        return index;
    }

    public long get(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        return this.buffer[index];
    }

    public int size() {
        return this.size;
    }
}

