/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.rple.internal.common.config.adapter;

import com.falsepattern.rple.internal.common.config.ColorConfigLoader;
import com.falsepattern.rple.internal.common.config.container.HexColor;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import lombok.Generated;

public final class HexColorJSONAdapter
extends TypeAdapter<HexColor> {
    public void write(JsonWriter out, HexColor value) {
        ColorConfigLoader.colorConfigGSON().toJson((Object)value.asColorHex(), String.class, out);
    }

    public HexColor read(JsonReader in) {
        String colorHex;
        try {
            colorHex = (String)ColorConfigLoader.colorConfigGSON().fromJson(in, String.class);
        }
        catch (JsonSyntaxException e) {
            ColorConfigLoader.logParsingError("Failed parsing hex color: {}", e.getMessage());
            return HexColor.INVALID_HEX_COLOR;
        }
        HexColor hexColor = new HexColor(colorHex);
        if (!hexColor.isValid()) {
            ColorConfigLoader.logParsingError("Invalid hex color: {}", hexColor);
        }
        return hexColor;
    }

    @Generated
    public HexColorJSONAdapter() {
    }
}

