/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.rple.internal.common.world;

import com.falsepattern.lumi.api.world.LumiWorld;
import com.falsepattern.lumi.api.world.LumiWorldProvider;
import com.falsepattern.rple.api.common.color.ColorChannel;
import com.falsepattern.rple.internal.common.world.RPLEWorldRoot;
import lombok.Generated;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RPLEWorldProvider
implements LumiWorldProvider {
    private static final String RED_WORLD_PROVIDER_ID = "rple_" + (Object)((Object)ColorChannel.RED_CHANNEL) + "_world_provider";
    private static final String GREEN_WORLD_PROVIDER_ID = "rple_" + (Object)((Object)ColorChannel.GREEN_CHANNEL) + "_world_provider";
    private static final String BLUE_WORLD_PROVIDER_ID = "rple_" + (Object)((Object)ColorChannel.BLUE_CHANNEL) + "_world_provider";
    private final ColorChannel channel;
    private String worldProviderVersion;
    private static final RPLEWorldProvider RED_CHANNEL_INSTANCE = new RPLEWorldProvider(ColorChannel.RED_CHANNEL);
    private static final RPLEWorldProvider GREEN_CHANNEL_INSTANCE = new RPLEWorldProvider(ColorChannel.GREEN_CHANNEL);
    private static final RPLEWorldProvider BLUE_CHANNEL_INSTANCE = new RPLEWorldProvider(ColorChannel.BLUE_CHANNEL);

    private RPLEWorldProvider(ColorChannel channel) {
        this.channel = channel;
        this.worldProviderVersion = "2.1.4_0x00000000";
    }

    public static RPLEWorldProvider redRPLEWorldProvider() {
        return RED_CHANNEL_INSTANCE;
    }

    public static RPLEWorldProvider greenRPLEWorldProvider() {
        return GREEN_CHANNEL_INSTANCE;
    }

    public static RPLEWorldProvider blueRPLEWorldProvider() {
        return BLUE_CHANNEL_INSTANCE;
    }

    @NotNull
    public String worldProviderID() {
        switch (this.channel) {
            default: {
                return RED_WORLD_PROVIDER_ID;
            }
            case GREEN_CHANNEL: {
                return GREEN_WORLD_PROVIDER_ID;
            }
            case BLUE_CHANNEL: 
        }
        return BLUE_WORLD_PROVIDER_ID;
    }

    @Nullable
    public LumiWorld provideWorld(@Nullable World worldBase) {
        if (!(worldBase instanceof RPLEWorldRoot)) {
            return null;
        }
        RPLEWorldRoot worldRoot = (RPLEWorldRoot)worldBase;
        return worldRoot.rple$world(this.channel);
    }

    public void applyConfigHashCode(String configHashCode) {
        this.worldProviderVersion = "2.1.4_" + configHashCode;
    }

    @Generated
    public String worldProviderVersion() {
        return this.worldProviderVersion;
    }
}

