/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.rple.api.client;

import com.falsepattern.lib.StableAPI;
import com.falsepattern.rple.api.client.CookieMonster;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;

@StableAPI(since="1.0.0")
public final class ClientColorHelper {
    private static final int VANILLA_BLOCK_MASK = 255;
    private static final int VANILLA_SKY_MASK = 0xFF0000;
    private static final int CHANNEL_8BIT_TO_VANILLA_BLOCK = 0;
    private static final int CHANNEL_4BIT_TO_VANILLA_BLOCK = 4;
    private static final int CHANNEL_8BIT_TO_VANILLA_SKY = 16;
    private static final int CHANNEL_4BIT_TO_VANILLA_SKY = 20;
    private static final int COMPRESSED_BLOCK_MASK = 255;
    private static final int COMPRESSED_SKY_MASK = 65280;
    private static final int COMPRESSED_MASK = 65535;
    private static final int RGB64_RED_OFFSET = 32;
    private static final int RGB64_GREEN_OFFSET = 16;
    private static final int RGB64_BLUE_OFFSET = 0;
    private static final int CHANNEL_8BIT_TO_RGB64_RED_SKY = 40;
    private static final int CHANNEL_4BIT_TO_RGB64_RED_SKY = 44;
    private static final int CHANNEL_8BIT_TO_RGB64_RED_BLOCK = 32;
    private static final int CHANNEL_4BIT_TO_RGB64_RED_BLOCK = 36;
    private static final int CHANNEL_8BIT_TO_RGB64_GREEN_SKY = 24;
    private static final int CHANNEL_4BIT_TO_RGB64_GREEN_SKY = 28;
    private static final int CHANNEL_8BIT_TO_RGB64_GREEN_BLOCK = 16;
    private static final int CHANNEL_4BIT_TO_RGB64_GREEN_BLOCK = 20;
    private static final int CHANNEL_8BIT_TO_RGB64_BLUE_SKY = 8;
    private static final int CHANNEL_4BIT_TO_RGB64_BLUE_SKY = 12;
    private static final int CHANNEL_8BIT_TO_RGB64_BLUE_BLOCK = 0;
    private static final int CHANNEL_4BIT_TO_RGB64_BLUE_BLOCK = 4;
    private static final long RGB64_4BIT_LOSSY_CHECK_MASK = 0xF0F0F0F0F0FL;
    private static final int CHANNEL_4BIT_TO_RGB32_RED_SKY = 12;
    private static final int CHANNEL_4BIT_TO_RGB32_GREEN_SKY = 16;
    private static final int CHANNEL_4BIT_TO_RGB32_BLUE_SKY = 20;
    private static final int CHANNEL_4BIT_TO_RGB32_RED_BLOCK = 0;
    private static final int CHANNEL_4BIT_TO_RGB32_GREEN_BLOCK = 4;
    private static final int CHANNEL_4BIT_TO_RGB32_BLUE_BLOCK = 8;
    private static final int RGB32_SHIFT_MAX = 20;
    private static final int RGB32_BLOCK_REMOVE_BITMASK = -4096;
    @StableAPI.Expose
    public static final int RGB32_MAX_SKYLIGHT_NO_BLOCKLIGHT = 0xFFF000;
    @StableAPI.Expose
    public static final int RGB32_NO_SKYLIGHT_NO_BLOCKLIGHT = 0;

    private ClientColorHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @StableAPI.Expose
    public static int RGB32FromChannels4Bit(int skyR, int skyG, int skyB, int blockR, int blockG, int blockB) {
        skyR = (skyR & 0xF) << 12;
        skyG = (skyG & 0xF) << 16;
        skyB = (skyB & 0xF) << 20;
        blockR = (blockR & 0xF) << 0;
        blockG = (blockG & 0xF) << 4;
        blockB = (blockB & 0xF) << 8;
        return skyR | skyG | skyB | blockR | blockG | blockB;
    }

    @StableAPI.Expose
    public static int RGB32FromChannels4BitBlock(int blockR, int blockG, int blockB) {
        blockR = (blockR & 0xF) << 0;
        blockG = (blockG & 0xF) << 4;
        blockB = (blockB & 0xF) << 8;
        return blockR | blockG | blockB;
    }

    @StableAPI.Expose
    public static int tryRGB32FromRGB64(long rgb64) {
        if ((rgb64 & 0xF0F0F0F0F0FL) != 0L) {
            return -1;
        }
        int rgb32 = 0;
        rgb32 |= ((int)(rgb64 >>> 36) & 0xF) << 0;
        rgb32 |= ((int)(rgb64 >>> 20) & 0xF) << 4;
        rgb32 |= ((int)(rgb64 >>> 4) & 0xF) << 8;
        rgb32 |= ((int)(rgb64 >>> 44) & 0xF) << 12;
        rgb32 |= ((int)(rgb64 >>> 28) & 0xF) << 16;
        return rgb32 |= ((int)(rgb64 >>> 12) & 0xF) << 20;
    }

    @StableAPI.Expose
    public static int RGB32ClampMinBlockChannels(int rgb32, int minRedBlockLight, int minGreenBlockLight, int minBlueBlockLight) {
        int containedRedBlockLight = rgb32 >>> 0 & 0xF;
        int containedGreenBlockLight = rgb32 >>> 4 & 0xF;
        int containedBlueBlockLight = rgb32 >>> 8 & 0xF;
        int redBlockLight = Math.max(minRedBlockLight &= 0xF, containedRedBlockLight);
        int greenBlockLight = Math.max(minGreenBlockLight &= 0xF, containedGreenBlockLight);
        int blueBlockLight = Math.max(minBlueBlockLight &= 0xF, containedBlueBlockLight);
        rgb32 &= 0xFFFFF000;
        rgb32 |= redBlockLight << 0;
        rgb32 |= greenBlockLight << 4;
        return rgb32 |= blueBlockLight << 8;
    }

    @StableAPI.Expose
    public static int RGB32Max(int lightValueA, int lightValueB, int lightValueC, int lightValueD, int lightValueE) {
        int result = 0;
        for (int shift = 0; shift <= 20; shift += 4) {
            int a = lightValueA >>> shift & 0xF;
            int b = lightValueB >>> shift & 0xF;
            int c = lightValueC >>> shift & 0xF;
            int d = lightValueD >>> shift & 0xF;
            int e = lightValueE >>> shift & 0xF;
            int max = 0;
            max = Math.max(max, a);
            max = Math.max(max, b);
            max = Math.max(max, c);
            max = Math.max(max, d);
            max = Math.max(max, e);
            result |= max << shift;
        }
        return result;
    }

    @StableAPI.Expose
    public static int vanillaFromBlockSky4Bit(int blockLightValue, int skyLightValue) {
        return (blockLightValue & 0xF) << 4 | (skyLightValue & 0xF) << 20;
    }

    @StableAPI.Expose
    public static int block4BitFromVanilla(int brightness) {
        return (brightness & 0xFF) >>> 4;
    }

    @StableAPI.Expose
    public static int sky4BitFromVanilla(int brightness) {
        return (brightness & 0xFF0000) >>> 20;
    }

    @StableAPI.Expose
    public static int vanillaFromBlockSky8Bit(int block, int sky) {
        return (sky & 0xFF) << 16 | (block & 0xFF) << 0;
    }

    @StableAPI.Expose
    public static int block8BitFromVanilla(int brightness) {
        return (brightness & 0xFF) >>> 0;
    }

    @StableAPI.Expose
    public static int sky8BitFromVanilla(int brightness) {
        return (brightness & 0xFF0000) >>> 16;
    }

    @StableAPI.Expose
    public static int vanillaFromRGB64Red(long rgb64) {
        return ClientColorHelper.vanillaFromCompressed((int)(rgb64 >>> 32 & 0xFFFFL));
    }

    @StableAPI.Expose
    public static int vanillaFromRGB64Green(long rgb64) {
        return ClientColorHelper.vanillaFromCompressed((int)(rgb64 >>> 16 & 0xFFFFL));
    }

    @StableAPI.Expose
    public static int vanillaFromRGB64Blue(long rgb64) {
        return ClientColorHelper.vanillaFromCompressed((int)(rgb64 >>> 0 & 0xFFFFL));
    }

    @StableAPI.Expose
    public static int vanillaFromRGB64Max(long rgb64) {
        int redCompressed = (int)(rgb64 >>> 32 & 0xFFFFL);
        int greenCompressed = (int)(rgb64 >>> 16 & 0xFFFFL);
        int blueCompressed = (int)(rgb64 >>> 0 & 0xFFFFL);
        return ClientColorHelper.vanillaFromCompressed(ClientColorHelper.max3(redCompressed, greenCompressed, blueCompressed, 65280) | ClientColorHelper.max3(redCompressed, greenCompressed, blueCompressed, 255));
    }

    @StableAPI.Expose
    public static long RGB64FromVanillaRGB(int red, int green, int blue) {
        return (long)ClientColorHelper.compressedFromVanilla(red) << 32 | (long)ClientColorHelper.compressedFromVanilla(green) << 16 | (long)ClientColorHelper.compressedFromVanilla(blue) << 0;
    }

    @StableAPI.Expose
    public static long RGB64FromVanillaMonochrome(int brightness) {
        long compressed = ClientColorHelper.compressedFromVanilla(brightness);
        return compressed << 32 | compressed << 16 | compressed << 0;
    }

    @StableAPI.Expose
    public static long RGB64FromRGB32(int rgb32) {
        long rgb64 = 0L;
        rgb64 |= (long)(rgb32 >>> 0 & 0xF) << 36;
        rgb64 |= (long)(rgb32 >>> 4 & 0xF) << 20;
        rgb64 |= (long)(rgb32 >>> 8 & 0xF) << 4;
        rgb64 |= (long)(rgb32 >>> 12 & 0xF) << 44;
        rgb64 |= (long)(rgb32 >>> 16 & 0xF) << 28;
        return rgb64 |= (long)(rgb32 >>> 20 & 0xF) << 12;
    }

    @StableAPI.Expose
    public static long RGB64Max(long a, long b) {
        long result = 0L;
        for (int i = 0; i <= 40; i += 8) {
            long mask = 255L << i;
            long cA = a & mask;
            long cB = b & mask;
            result |= Math.max(cA, cB);
        }
        return result;
    }

    @StableAPI.Expose(since="1.5.0")
    public static long RGB64ForEach(long x, Int2IntFunction f) {
        long result = 0L;
        for (int i = 0; i <= 40; i += 8) {
            long c = x >>> i & 0xFFL;
            result |= ((long)f.applyAsInt((int)c) & 0xFFL) << i;
        }
        return result;
    }

    @StableAPI.Expose
    public static long RGB64MixAOBrightness(long a, long b, double aMul, double bMul) {
        long result = 0L;
        for (int i = 0; i <= 40; i += 8) {
            result |= ClientColorHelper.RGB64LerpChannel(a, b, aMul, bMul, i);
        }
        return result;
    }

    @StableAPI.Expose
    public static long RGB64MixAOBrightness(long TL, long BL, long BR, long TR, double lerpTB, double lerpLR) {
        double lTL = (1.0 - lerpTB) * (1.0 - lerpLR);
        double lTR = (1.0 - lerpTB) * lerpLR;
        double lBL = lerpTB * (1.0 - lerpLR);
        double lBR = lerpTB * lerpLR;
        return ClientColorHelper.RGB64MixAOBrightness(TL, TR, BL, BR, lTL, lTR, lBL, lBR);
    }

    @StableAPI.Expose
    public static long RGB64MixAOBrightness(long a, long b, long c, long d, double aMul, double bMul, double cMul, double dMul) {
        long result = 0L;
        for (int i = 0; i <= 40; i += 8) {
            result |= ClientColorHelper.RGB64MixAoBrightnessChannel(a, b, c, d, aMul, bMul, cMul, dMul, i);
        }
        return result;
    }

    @StableAPI.Expose
    public static long RGB64Average(long a, long b, boolean ignoreZero) {
        long result = 0L;
        for (int i = 0; i <= 40; i += 8) {
            result |= ClientColorHelper.RGB64AverageChannel(a, b, i, ignoreZero);
        }
        return result;
    }

    @StableAPI.Expose
    public static long RGB64Average(long a, long b, long c, long d, boolean ignoreZero) {
        long result = 0L;
        if (ignoreZero) {
            for (int i = 0; i <= 40; i += 8) {
                result |= ClientColorHelper.RGB64AverageChannelIgnoreZero(a, b, c, d, i);
            }
        } else {
            for (int i = 0; i <= 40; i += 8) {
                result |= ClientColorHelper.RGB64AverageChannel(a, b, c, d, i);
            }
        }
        return result;
    }

    @StableAPI.Expose
    public static long RGB64Average(long[] values, int n, boolean ignoreZero) {
        long result = 0L;
        for (int i = 0; i <= 40; i += 8) {
            result |= ClientColorHelper.RGB64AverageChannel(values, n, i, ignoreZero);
        }
        return result;
    }

    public static long RGB64Mul(long x, float f) {
        long result = 0L;
        for (int i = 0; i <= 40; i += 8) {
            result |= ClientColorHelper.RGB64MulChannel(x, i, f);
        }
        return result;
    }

    @StableAPI.Expose
    public static int tessFromRGB64Red(long rgb64) {
        return ClientColorHelper.tessFromVanilla(ClientColorHelper.vanillaFromCompressed((int)(rgb64 >>> 32 & 0xFFFFL)));
    }

    @StableAPI.Expose
    public static int tessFromRGB64Green(long rgb64) {
        return ClientColorHelper.tessFromVanilla(ClientColorHelper.vanillaFromCompressed((int)(rgb64 >>> 16 & 0xFFFFL)));
    }

    @StableAPI.Expose
    public static int tessFromRGB64Blue(long rgb64) {
        return ClientColorHelper.tessFromVanilla(ClientColorHelper.vanillaFromCompressed((int)(rgb64 >>> 0 & 0xFFFFL)));
    }

    @StableAPI.Expose
    public static int tessFromVanilla(int vanilla) {
        short lightMapBlock = ClientColorHelper.remapToShort(vanilla & 0xFF);
        short lightMapSky = ClientColorHelper.remapToShort(vanilla >> 16 & 0xFF);
        return lightMapBlock & 0xFFFF | lightMapSky << 16;
    }

    @StableAPI.Expose
    public static int cookieMax(int cookieA, int cookieB) {
        return CookieMonster.cookieFromRGB64(ClientColorHelper.RGB64Max(CookieMonster.RGB64FromCookie(cookieA), CookieMonster.RGB64FromCookie(cookieB)));
    }

    @StableAPI.Expose
    public static int cookieMixAOBrightness(int cookieTL, int cookieBL, int cookieBR, int cookieTR, double lerpTB, double lerpLR) {
        long TL = CookieMonster.RGB64FromCookie(cookieTL);
        long BL = CookieMonster.RGB64FromCookie(cookieBL);
        long BR = CookieMonster.RGB64FromCookie(cookieBR);
        long TR = CookieMonster.RGB64FromCookie(cookieTR);
        return CookieMonster.cookieFromRGB64(ClientColorHelper.RGB64MixAOBrightness(TL, BL, BR, TR, lerpTB, lerpLR));
    }

    @StableAPI.Expose
    public static int cookieMixAOBrightness(int cookieA, int cookieB, int cookieC, int cookieD, double aMul, double bMul, double cMul, double dMul) {
        long a = CookieMonster.RGB64FromCookie(cookieA);
        long b = CookieMonster.RGB64FromCookie(cookieB);
        long c = CookieMonster.RGB64FromCookie(cookieC);
        long d = CookieMonster.RGB64FromCookie(cookieD);
        return CookieMonster.cookieFromRGB64(ClientColorHelper.RGB64MixAOBrightness(a, b, c, d, aMul, bMul, cMul, dMul));
    }

    @StableAPI.Expose
    public static int cookieMixAOBrightness(int cookieA, int cookieB, double aMul, double bMul) {
        long a = CookieMonster.RGB64FromCookie(cookieA);
        long b = CookieMonster.RGB64FromCookie(cookieB);
        return CookieMonster.cookieFromRGB64(ClientColorHelper.RGB64MixAOBrightness(a, b, aMul, bMul));
    }

    @StableAPI.Expose
    public static int cookieAverage(boolean ignoreZero, int cookieA, int cookieB) {
        long a = CookieMonster.RGB64FromCookie(cookieA);
        long b = CookieMonster.RGB64FromCookie(cookieB);
        return CookieMonster.cookieFromRGB64(ClientColorHelper.RGB64Average(a, b, ignoreZero));
    }

    @StableAPI.Expose
    public static int cookieAverage(boolean ignoreZero, int cookieA, int cookieB, int cookieC, int cookieD) {
        long a = CookieMonster.RGB64FromCookie(cookieA);
        long b = CookieMonster.RGB64FromCookie(cookieB);
        long c = CookieMonster.RGB64FromCookie(cookieC);
        long d = CookieMonster.RGB64FromCookie(cookieD);
        return CookieMonster.cookieFromRGB64(ClientColorHelper.RGB64Average(a, b, c, d, ignoreZero));
    }

    @StableAPI.Expose
    public static int cookieAverage(boolean ignoreZero, int ... values) {
        long[] rgb64 = new long[values.length];
        for (int i = 0; i < values.length; ++i) {
            rgb64[i] = CookieMonster.RGB64FromCookie(values[i]);
        }
        return CookieMonster.cookieFromRGB64(ClientColorHelper.RGB64Average(rgb64, rgb64.length, ignoreZero));
    }

    public static int cookieMul(int cookie, float f) {
        return CookieMonster.cookieFromRGB64(ClientColorHelper.RGB64Mul(CookieMonster.RGB64FromCookie(cookie), f));
    }

    private static short remapToShort(int n) {
        n = Math.min(n, 240);
        float normalized = (float)n / 240.0f;
        return (short)Math.round(normalized * 65535.0f + -32768.0f);
    }

    private static long RGB64LerpChannel(long a, long b, double aMul, double bMul, int offset) {
        double resultA = (double)ClientColorHelper.unit(a, offset) * aMul;
        double resultB = (double)ClientColorHelper.unit(b, offset) * bMul;
        return ((long)(resultA + resultB) & 0xFFL) << offset;
    }

    private static long RGB64AverageChannel(long a, long b, int shift, boolean ignoreZero) {
        int unitA = ClientColorHelper.unit(a, shift);
        int unitB = ClientColorHelper.unit(b, shift);
        if (ignoreZero) {
            if (unitA == 0) {
                return unitB;
            }
            return (long)unitA << shift;
        }
        return (long)((int)((float)(unitA + unitB) / 2.0f) & 0xFF) << shift;
    }

    private static long RGB64AverageChannel(long a, long b, long c, long d, int shift) {
        float light = 0.0f;
        light += (float)ClientColorHelper.unit(a, shift);
        light += (float)ClientColorHelper.unit(b, shift);
        light += (float)ClientColorHelper.unit(c, shift);
        light += (float)ClientColorHelper.unit(d, shift);
        return (long)((int)(light /= 4.0f) & 0xFF) << shift;
    }

    private static long RGB64AverageChannelIgnoreZero(long a, long b, long c, long d, int shift) {
        int count = 0;
        float light = 0.0f;
        int unitA = ClientColorHelper.unit(a, shift);
        int unitB = ClientColorHelper.unit(b, shift);
        int unitC = ClientColorHelper.unit(c, shift);
        int unitD = ClientColorHelper.unit(d, shift);
        if (unitA != 0) {
            ++count;
            light += (float)unitA;
        }
        if (unitB != 0) {
            ++count;
            light += (float)unitB;
        }
        if (unitC != 0) {
            ++count;
            light += (float)unitC;
        }
        if (unitD != 0) {
            ++count;
            light += (float)unitD;
        }
        if (count != 0) {
            light /= (float)count;
        }
        return (long)((int)light & 0xFF) << shift;
    }

    private static long RGB64AverageChannel(long[] rgb64Values, int n, int shift, boolean ignoreZero) {
        int count = 0;
        float light = 0.0f;
        for (int i = 0; i < n; ++i) {
            long rgb64 = rgb64Values[i];
            int value = ClientColorHelper.unit(rgb64, shift);
            if (ignoreZero && value == 0) continue;
            ++count;
            light += (float)value;
        }
        if (count != 0) {
            light /= (float)count;
        }
        return (long)((int)light & 0xFF) << shift;
    }

    private static long RGB64MulChannel(long x, int shift, float f) {
        float res = (float)ClientColorHelper.unit(x, shift) * f;
        return (long)((int)res & 0xFF) << shift;
    }

    private static int max3(int red, int green, int blue, int mask) {
        return Math.max(Math.max(red & mask, green & mask), blue & mask);
    }

    private static int compressedFromVanilla(int vanilla) {
        return (vanilla & 0xFF0000) >>> 8 | vanilla & 0xFF;
    }

    private static int vanillaFromCompressed(int compressed) {
        return (compressed & 0xFF00) << 8 | compressed & 0xFF;
    }

    private static long RGB64MixAoBrightnessChannel(long a, long b, long c, long d, double aMul, double bMul, double cMul, double dMul, int channel) {
        double fA = (double)ClientColorHelper.unit(a, channel) * aMul;
        double fB = (double)ClientColorHelper.unit(b, channel) * bMul;
        double fC = (double)ClientColorHelper.unit(c, channel) * cMul;
        double fD = (double)ClientColorHelper.unit(d, channel) * dMul;
        return (long)((int)(fA + fB + fC + fD) & 0xFF) << channel;
    }

    private static int unit(long val, int channel) {
        return (int)(val >>> channel & 0xFFL);
    }
}

