/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.rple.api.client;

import com.falsepattern.lib.StableAPI;
import com.falsepattern.rple.api.client.ClientColorHelper;
import com.falsepattern.rple.internal.Compat;
import com.falsepattern.rple.internal.common.collection.CircularLongBuffer;
import com.falsepattern.rple.internal.common.config.RPLEConfig;
import com.falsepattern.rple.internal.common.util.FastThreadLocal;
import com.falsepattern.rple.internal.common.util.LogHelper;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.Logger;

@StableAPI(since="1.0.0")
public final class CookieMonster {
    private static final Logger LOG = LogHelper.createLogger("CookieMonster");
    private static final int NUM_INDICES = 0x100000;
    private static final int INDEX_SHIFT = 8;
    private static final int PARITY_BIT = 1;
    private static final int INDEX_MASK = 0xFFFFF00;
    private static final int CHECK_SHIFT = 1;
    private static final int NUM_CHECKS = 128;
    private static final int CHECK_MASK = 254;
    private static final int COOKIE_BIT = 0x40000000;
    private static final int ZERO_MASK_COOKIE = -1342177280;
    private static final int RGB_BIT = 0x20000000;
    private static final int RGB_MASK = 0xFFFFFF;
    private static final int ZERO_MASK_RGB = -1627389952;
    private static final int BRIGHTNESS_MASK = 0xFF00FF;
    private static final long BROKEN_WARN_COLOR;
    private static final FastThreadLocal.FixedValue<ThreadState> THREAD_STATE;

    @StableAPI.Expose
    public static int cookieFromRGB64(long rgb64) {
        int rgb = ClientColorHelper.tryRGB32FromRGB64(rgb64);
        if (rgb != -1) {
            return rgb | 0x40000000 | 0x20000000;
        }
        ThreadState state = THREAD_STATE.get();
        int index = state.lightValues.put(rgb64);
        int cookie = index << 8 & 0xFFFFF00 | state.check << 1 | 0x40000000;
        return cookie | CookieMonster.parity(cookie);
    }

    @StableAPI.Expose
    public static int cookieFromRGB32(int rgb32) {
        return rgb32 & 0xFFFFFF | 0x40000000 | 0x20000000;
    }

    @StableAPI.Expose
    public static long RGB64FromCookie(int cookie) {
        switch (CookieMonster.inspectValue(cookie)) {
            case COOKIE: {
                if ((cookie & 0x20000000) != 0) {
                    return ClientColorHelper.RGB64FromRGB32(cookie & 0xFFFFFF);
                }
                return THREAD_STATE.get().lightValues.get((cookie & 0xFFFFF00) >>> 8);
            }
            case VANILLA: {
                return ClientColorHelper.RGB64FromVanillaRGB(cookie, cookie, cookie);
            }
        }
        if (LogHelper.shouldLogDebug(RPLEConfig.Debug.DEBUG_COOKIE_MONSTER)) {
            LOG.warn("Illegal brightness value (Did a mod treat a cookie as a regular brightness value?)");
            LOG.trace("Stack trace:", (Throwable)new IllegalStateException());
        }
        return BROKEN_WARN_COLOR;
    }

    @StableAPI.Expose
    public static IntType inspectValue(int potentialCookie) {
        if ((potentialCookie & 0x40000000) == 0) {
            if ((potentialCookie & 0xFF00FF) == potentialCookie) {
                return IntType.VANILLA;
            }
            return IntType.BROKEN;
        }
        if ((potentialCookie & 0x20000000) != 0 && (potentialCookie & 0x9F000000) == 0) {
            return IntType.COOKIE;
        }
        if (CookieMonster.parity(potentialCookie) == 0 && (potentialCookie & 0xB0000000) == 0) {
            ThreadState state = THREAD_STATE.get();
            if ((potentialCookie & 0xFE) >>> 1 != state.check && LogHelper.shouldLogDebug(RPLEConfig.Debug.DEBUG_COOKIE_MONSTER)) {
                LOG.warn("Cookie passed through thread boundary{}", new Object[]{Compat.falseTweaksThreadedChunksEnabled() ? " (Is a mod not compatible with FalseTweaks Threaded Chunks?)" : ""});
                LOG.trace("Stack trace:", (Throwable)new IllegalStateException());
            }
            return IntType.COOKIE;
        }
        return IntType.BROKEN;
    }

    private static int parity(int x) {
        int y = x ^ x >>> 1;
        y ^= y >>> 2;
        y ^= y >>> 4;
        y ^= y >>> 8;
        y ^= y >>> 16;
        return y & 1;
    }

    static {
        THREAD_STATE = new FastThreadLocal.FixedValue<ThreadState>(() -> new ThreadState());
        int redBrightness = ClientColorHelper.vanillaFromBlockSky4Bit(15, 15);
        int greenBrightness = ClientColorHelper.vanillaFromBlockSky4Bit(0, 0);
        int blueBrightness = ClientColorHelper.vanillaFromBlockSky4Bit(0, 0);
        BROKEN_WARN_COLOR = ClientColorHelper.RGB64FromVanillaRGB(redBrightness, greenBrightness, blueBrightness);
    }

    private static class ThreadState {
        private static final AtomicInteger checkIndexCounter = new AtomicInteger(0);
        private final int check = checkIndexCounter.getAndUpdate(x -> (x + 1) % 128);
        private final CircularLongBuffer lightValues = new CircularLongBuffer(0x100000);

        private ThreadState() {
        }
    }

    public static enum IntType {
        COOKIE,
        VANILLA,
        BROKEN;

    }
}

