/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.rple.api.client;

import com.falsepattern.lib.StableAPI;
import com.falsepattern.lumi.api.lighting.LightType;
import com.falsepattern.rple.api.client.ClientColorHelper;
import com.falsepattern.rple.api.client.CookieMonster;
import com.falsepattern.rple.api.common.ServerColorHelper;
import com.falsepattern.rple.api.common.block.RPLEBlock;
import com.falsepattern.rple.api.common.color.ColorChannel;
import com.falsepattern.rple.api.common.color.DefaultColor;
import com.falsepattern.rple.internal.client.storage.RPLEClientBlockStorage;
import com.falsepattern.rple.internal.common.cache.RPLEBlockStorageRoot;
import com.falsepattern.rple.internal.common.chunk.RPLEChunk;
import com.falsepattern.rple.internal.common.chunk.RPLEChunkRoot;
import com.falsepattern.rple.internal.mixin.extension.ExtendedOpenGlHelper;
import net.minecraft.block.Block;
import net.minecraft.world.IBlockAccess;
import org.jetbrains.annotations.NotNull;

@StableAPI(since="1.0.0")
public final class RPLETessBrightnessUtil {
    private RPLETessBrightnessUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @StableAPI.Expose
    public static void setLightMapTextureCoordsRGB64(long rgb64) {
        ExtendedOpenGlHelper.setLightMapTextureCoordsRGB64(rgb64);
    }

    @StableAPI.Expose
    public static long lastLightMapRGB64() {
        return ExtendedOpenGlHelper.lastRGB64();
    }

    @StableAPI.Expose
    public static int getRGBBrightnessForTessellator(@NotNull IBlockAccess world, int posX, int posY, int posZ) {
        return RPLETessBrightnessUtil.getRGBBrightnessForTessellator(world, posX, posY, posZ, 0);
    }

    @StableAPI.Expose
    public static int getRGBBrightnessForTessellator(@NotNull IBlockAccess world, int posX, int posY, int posZ, int minBlockLight) {
        return RPLETessBrightnessUtil.getRGBBrightnessForTessellator(world, posX, posY, posZ, minBlockLight, minBlockLight, minBlockLight);
    }

    @StableAPI.Expose
    public static int getRGBBrightnessForTessellator(@NotNull IBlockAccess world, int posX, int posY, int posZ, int minRedBlockLight, int minGreenBlockLight, int minBlueBlockLight) {
        if (!(world instanceof RPLEBlockStorageRoot)) {
            return RPLETessBrightnessUtil.errorBrightnessForTessellator();
        }
        if (world instanceof RPLEClientBlockStorage) {
            return RPLETessBrightnessUtil.getRGB32BrightnessForTessellatorFastPath(world, posX, posY, posZ, minRedBlockLight, minGreenBlockLight, minBlueBlockLight);
        }
        return RPLETessBrightnessUtil.getRGB32BrightnessForTessellatorSlowPath(world, posX, posY, posZ, minRedBlockLight, minGreenBlockLight, minBlueBlockLight);
    }

    @StableAPI.Expose
    private static int getRGB32BrightnessForTessellatorFastPath(@NotNull IBlockAccess world, int posX, int posY, int posZ, int minRedBlockLight, int minGreenBlockLight, int minBlueBlockLight) {
        RPLEBlockStorageRoot worldRoot = (RPLEBlockStorageRoot)world;
        RPLEClientBlockStorage cbs = (RPLEClientBlockStorage)world;
        if (posY > 255) {
            return CookieMonster.cookieFromRGB32(worldRoot.lumi$hasSky() ? 0xFFF000 : 0);
        }
        if (posY < 0) {
            posY = 0;
        }
        Block block = world.func_147439_a(posX, posY, posZ);
        int raw = cbs.rple$getRGBLightValue(block.func_149710_n(), posX, posY, posZ);
        int rgb = ClientColorHelper.RGB32ClampMinBlockChannels(raw, minRedBlockLight, minGreenBlockLight, minBlueBlockLight);
        return CookieMonster.cookieFromRGB32(rgb);
    }

    @StableAPI.Expose
    private static int getRGB32BrightnessForTessellatorSlowPath(@NotNull IBlockAccess world, int posX, int posY, int posZ, int minRedBlockLight, int minGreenBlockLight, int minBlueBlockLight) {
        RPLEBlockStorageRoot worldRoot = (RPLEBlockStorageRoot)world;
        RPLEChunkRoot chunk = worldRoot.rple$getChunkRootFromBlockPosIfExists(posX, posZ);
        RPLEChunk cr = chunk == null ? null : chunk.rple$chunk(ColorChannel.RED_CHANNEL);
        RPLEChunk cg = chunk == null ? null : chunk.rple$chunk(ColorChannel.GREEN_CHANNEL);
        RPLEChunk cb = chunk == null ? null : chunk.rple$chunk(ColorChannel.BLUE_CHANNEL);
        int redBrightness = worldRoot.rple$blockStorage(ColorChannel.RED_CHANNEL).rple$getChannelBrightnessForTessellator(cr, posX, posY, posZ, minRedBlockLight);
        int greenBrightness = worldRoot.rple$blockStorage(ColorChannel.GREEN_CHANNEL).rple$getChannelBrightnessForTessellator(cg, posX, posY, posZ, minGreenBlockLight);
        int blueBrightness = worldRoot.rple$blockStorage(ColorChannel.BLUE_CHANNEL).rple$getChannelBrightnessForTessellator(cb, posX, posY, posZ, minBlueBlockLight);
        long raw = ClientColorHelper.RGB64FromVanillaRGB(redBrightness, greenBrightness, blueBrightness);
        return CookieMonster.cookieFromRGB64(raw);
    }

    @StableAPI.Expose
    public static int getBlockBrightnessForTessellator(@NotNull IBlockAccess world, @NotNull Block block, int blockMeta, int posX, int posY, int posZ) {
        short blockBrightnessColor = RPLEBlock.of(block).rple$getBrightnessColor(world, blockMeta, posX, posY, posZ);
        return RPLETessBrightnessUtil.createRGBBrightnessForTessellator(LightType.BLOCK_LIGHT_TYPE, blockBrightnessColor);
    }

    @StableAPI.Expose
    public static int errorBrightnessForTessellator() {
        short lightColor = DefaultColor.ERROR.rgb16();
        return RPLETessBrightnessUtil.createRGBBrightnessForTessellator(ServerColorHelper.red(lightColor), ServerColorHelper.green(lightColor), ServerColorHelper.blue(lightColor));
    }

    @StableAPI.Expose
    public static int createRGBBrightnessForTessellator(short lightColor) {
        return RPLETessBrightnessUtil.createRGBBrightnessForTessellator(ServerColorHelper.red(lightColor), ServerColorHelper.green(lightColor), ServerColorHelper.blue(lightColor));
    }

    @StableAPI.Expose
    public static int createRGBBrightnessForTessellator(int redLightValue, int greenLightValue, int blueLightValue) {
        return RPLETessBrightnessUtil.createRGBBrightnessForTessellator(redLightValue, greenLightValue, blueLightValue, redLightValue, greenLightValue, blueLightValue);
    }

    @StableAPI.Expose
    public static int createRGBBrightnessForTessellator(@NotNull LightType lightType, short lightColor) {
        return RPLETessBrightnessUtil.createRGBBrightnessForTessellator(lightType, ServerColorHelper.red(lightColor), ServerColorHelper.green(lightColor), ServerColorHelper.blue(lightColor));
    }

    @StableAPI.Expose
    public static int createRGBBrightnessForTessellator(@NotNull LightType lightType, int redLightValue, int greenLightValue, int blueLightValue) {
        switch (lightType) {
            default: {
                return RPLETessBrightnessUtil.createRGBBrightnessForTessellator(redLightValue, greenLightValue, blueLightValue, 0, 0, 0);
            }
            case SKY_LIGHT_TYPE: 
        }
        return RPLETessBrightnessUtil.createRGBBrightnessForTessellator(0, 0, 0, redLightValue, greenLightValue, blueLightValue);
    }

    @StableAPI.Expose
    public static int createRGBBrightnessForTessellator(short blockLightColor, short skyLightColor) {
        return RPLETessBrightnessUtil.createRGBBrightnessForTessellator(ServerColorHelper.red(blockLightColor), ServerColorHelper.green(blockLightColor), ServerColorHelper.blue(blockLightColor), ServerColorHelper.red(skyLightColor), ServerColorHelper.green(skyLightColor), ServerColorHelper.blue(skyLightColor));
    }

    @StableAPI.Expose
    public static int createRGBBrightnessForTessellator(int redBlockLight, int greenBlockLight, int blueBlockLight, int redSkyLight, int greenSkyLight, int blueSkyLight) {
        int redBrightness = ClientColorHelper.vanillaFromBlockSky4Bit(redBlockLight, redSkyLight);
        int greenBrightness = ClientColorHelper.vanillaFromBlockSky4Bit(greenBlockLight, greenSkyLight);
        int blueBrightness = ClientColorHelper.vanillaFromBlockSky4Bit(blueBlockLight, blueSkyLight);
        long rgb64 = ClientColorHelper.RGB64FromVanillaRGB(redBrightness, greenBrightness, blueBrightness);
        return CookieMonster.cookieFromRGB64(rgb64);
    }
}

