/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.rple.api.client.lightmap.vanilla;

import com.falsepattern.lib.util.MathUtil;
import com.falsepattern.rple.api.client.lightmap.RPLELightMapMask;
import com.falsepattern.rple.api.client.lightmap.RPLELightMapStrip;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import org.jetbrains.annotations.NotNull;

public class NightVisionMask
implements RPLELightMapMask {
    protected boolean generateNightVisionMask(RPLELightMapStrip output, float partialTick) {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return false;
        }
        if (!player.func_70644_a(Potion.field_76439_r)) {
            return false;
        }
        float amplitude = this.nightVisionIntensity((EntityPlayer)player, partialTick);
        output.fillLightMap(amplitude);
        return true;
    }

    @Override
    public void mutateBlockLightMap(@NotNull RPLELightMapStrip output, float partialTick) {
        this.mutateLightMap(output, partialTick);
    }

    @Override
    public void mutateSkyLightMap(@NotNull RPLELightMapStrip output, float partialTick) {
        this.mutateLightMap(output, partialTick);
    }

    protected void mutateLightMap(RPLELightMapStrip output, float partialTick) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityClientPlayerMP player = mc.field_71439_g;
        if (player == null) {
            return;
        }
        if (!player.func_70644_a(Potion.field_76439_r)) {
            return;
        }
        float power = this.nightVisionBrightness((EntityPlayer)player, partialTick);
        float powerInv = 1.0f - power;
        float[] R = output.lightMapRedData();
        float[] G = output.lightMapGreenData();
        float[] B = output.lightMapBlueData();
        for (int i = 0; i < 16; ++i) {
            float r = MathUtil.clamp((float)R[i], (float)1.0E-4f, (float)1.0f);
            float g = MathUtil.clamp((float)G[i], (float)1.0E-4f, (float)1.0f);
            float b = MathUtil.clamp((float)B[i], (float)1.0E-4f, (float)1.0f);
            float minInverse = Math.min(1.0f / r, Math.min(1.0f / g, 1.0f / b)) * power;
            r = r * powerInv + r * minInverse;
            g = g * powerInv + g * minInverse;
            b = b * powerInv + b * minInverse;
            R[i] = MathUtil.clamp((float)r, (float)0.0f, (float)1.0f);
            G[i] = MathUtil.clamp((float)g, (float)0.0f, (float)1.0f);
            B[i] = MathUtil.clamp((float)b, (float)0.0f, (float)1.0f);
        }
    }

    protected float nightVisionIntensity(EntityPlayer player, float partialTick) {
        return this.nightVisionBrightness(player, partialTick) * 3.0f;
    }

    protected float nightVisionBrightness(EntityPlayer player, float partialTick) {
        return Minecraft.func_71410_x().field_71460_t.func_82830_a(player, partialTick);
    }
}

