/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.rple.api.common.color;

import com.falsepattern.lib.StableAPI;
import com.falsepattern.rple.api.common.color.RPLENamedColor;
import org.jetbrains.annotations.ApiStatus;

@StableAPI(since="1.0.0")
public enum DefaultColor implements RPLENamedColor
{
    WHITE(4095),
    ORANGE(4042),
    MAGENTA(3855),
    LIGHT_BLUE(143),
    YELLOW(4080),
    LIME(2288),
    PINK(4013),
    GRAY(1365),
    LIGHT_GRAY(2730),
    CYAN(255),
    PURPLE(2575),
    BLUE(15),
    BROWN(2096),
    GREEN(240),
    RED(3840),
    BLACK(273),
    DIM_WHITE(2184),
    DIM_ORANGE(2149),
    DIM_MAGENTA(2056),
    DIM_LIGHT_BLUE(72),
    DIM_YELLOW(2176),
    DIM_LIME(1152),
    DIM_PINK(2134),
    DIM_GRAY(819),
    DIM_LIGHT_GRAY(1365),
    DIM_CYAN(136),
    DIM_PURPLE(1288),
    DIM_BLUE(8),
    DIM_BROWN(1056),
    DIM_GREEN(128),
    DIM_RED(2048),
    DIM_BLACK(273),
    TORCH_LIGHT(3496),
    ERROR(3840);

    private static final DefaultColor[] VALUES;
    @ApiStatus.Internal
    public static final String DEFAULT_COLOR_DOMAIN = "default";
    private final short rgb16;
    private final String paletteColorName;

    private DefaultColor(int rgb16) {
        this.rgb16 = (short)rgb16;
        this.paletteColorName = "default:" + this.name().toLowerCase();
    }

    @Override
    public String paletteColorName() {
        return this.paletteColorName;
    }

    @Override
    public short rgb16() {
        return this.rgb16;
    }

    @StableAPI.Expose
    public static DefaultColor fromVanillaBlockMeta(int blockMeta) {
        return VALUES[blockMeta &= 0xF];
    }

    @StableAPI.Expose
    public static DefaultColor dimFromVanillaBlockMeta(int blockMeta) {
        return VALUES[(blockMeta &= 0xF) + 16];
    }

    static {
        VALUES = DefaultColor.values();
    }
}

