/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.rple.internal;

import com.falsepattern.rple.internal.MultiLineLoadingException;
import com.falsepattern.rple.internal.common.config.RPLEConfig;
import com.falsepattern.rple.internal.common.util.FastThreadLocal;
import com.falsepattern.rple.internal.proxy.CommonProxy;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerAboutToStartEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppedEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.relauncher.FMLLaunchHandler;
import lombok.Generated;

@Mod(modid="rple", version="2.2.0", name="Right Proper Lighting Engine", acceptedMinecraftVersions="[1.7.10]", guiFactory="com.falsepattern.rple.internal.client.config.RPLEGuiFactory", dependencies="required-after:lumi@[1.2.0,);after:falsetweaks@[4.3.0,);required-after:falsepatternlib@[1.9.1,);")
public final class RightProperLightingEngine {
    @SidedProxy(clientSide="com.falsepattern.rple.internal.proxy.ClientProxy", serverSide="com.falsepattern.rple.internal.proxy.ServerProxy")
    public static CommonProxy PROXY;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        PROXY.preInit(evt);
        if (Loader.isModLoaded((String)"hardcoredarkness")) {
            RightProperLightingEngine.createSidedException("Remove the Hardcore Darkness mod and restart the game!\nRPLE has built-in hardcore darkness.");
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        PROXY.init(evt);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent evt) {
        PROXY.postInit(evt);
    }

    @Mod.EventHandler
    public void serverAboutToStart(FMLServerAboutToStartEvent evt) {
        PROXY.serverAboutToStart(evt);
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent evt) {
        PROXY.serverStarting(evt);
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent evt) {
        PROXY.serverStarted(evt);
    }

    @Mod.EventHandler
    public void serverStopping(FMLServerStoppingEvent evt) {
        PROXY.serverStopping(evt);
    }

    @Mod.EventHandler
    public void serverStopped(FMLServerStoppedEvent evt) {
        PROXY.serverStopped(evt);
    }

    private static void createSidedException(String text) {
        if (FMLLaunchHandler.side().isClient()) {
            throw ClientHelper.createException(text);
        }
        throw new Error(text);
    }

    @Generated
    public RightProperLightingEngine() {
    }

    static {
        RPLEConfig.poke();
        FastThreadLocal.setMainThread(Thread.currentThread());
    }

    private static class ClientHelper {
        private ClientHelper() {
        }

        private static RuntimeException createException(String text) {
            return new MultiLineLoadingException(text);
        }
    }
}

