/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.rple.internal.client.lightmap;

import com.falsepattern.rple.api.common.color.ColorChannel;
import com.falsepattern.rple.internal.Compat;
import com.falsepattern.rple.internal.client.lightmap.LightMapPipeline;
import com.falsepattern.rple.internal.client.lightmap.LightMapTexture;
import com.falsepattern.rple.internal.common.config.RPLEConfig;
import com.falsepattern.rple.internal.common.util.LogHelper;
import java.nio.ShortBuffer;
import lombok.Generated;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;

public final class LightMap {
    private static final Logger LOG = LogHelper.createLogger("LightMap");
    private static final LightMap INSTANCE = new LightMap();
    private LightMapTexture rTexture;
    private LightMapTexture gTexture;
    private LightMapTexture bTexture;
    private boolean texturesGenerated = false;
    public static int extMatrixMode = 5888;

    public static LightMap lightMap() {
        return INSTANCE;
    }

    public void generateTextures() {
        if (this.texturesGenerated) {
            return;
        }
        this.rTexture = LightMapTexture.createLightMapTexture(ColorChannel.RED_CHANNEL);
        this.gTexture = LightMapTexture.createLightMapTexture(ColorChannel.GREEN_CHANNEL);
        this.bTexture = LightMapTexture.createLightMapTexture(ColorChannel.BLUE_CHANNEL);
        this.texturesGenerated = true;
        LOG.info("Created LightMap");
        LightMap.clearBindTexture2D();
    }

    public void update(float partialTick) {
        int[] pixels = LightMapPipeline.lightMapPipeline().update(partialTick);
        this.rTexture.update(pixels);
        this.gTexture.update(pixels);
        this.bTexture.update(pixels);
        LightMap.clearBindTexture2D();
    }

    public void toggleEnabled(boolean enabled) {
        this.rTexture.toggleEnabled(enabled);
        this.gTexture.toggleEnabled(enabled);
        this.bTexture.toggleEnabled(enabled);
        if (!Compat.shadersEnabled()) {
            LightMap.clearActiveTexture();
        }
    }

    public void disable() {
        this.resetScale();
    }

    public void enable() {
        this.rescale();
        this.bind();
    }

    public void bind() {
        this.rTexture.bind();
        this.gTexture.bind();
        this.bTexture.bind();
        LightMap.clearActiveTexture();
    }

    public void resetScale() {
        this.rTexture.resetScale();
        this.gTexture.resetScale();
        this.bTexture.resetScale();
        LightMap.clearMatrixMode();
        LightMap.clearActiveTexture();
    }

    public void rescale() {
        this.rTexture.rescale();
        this.gTexture.rescale();
        this.bTexture.rescale();
        LightMap.clearMatrixMode();
        LightMap.clearActiveTexture();
    }

    public void enableVertexPointers(ShortBuffer buffer) {
        this.rTexture.enableVertexPointer(buffer);
        this.gTexture.enableVertexPointer(buffer);
        this.bTexture.enableVertexPointer(buffer);
        LightMap.clearActiveClientTexture();
    }

    public void enableVertexPointersVBO() {
        this.rTexture.enableVertexPointerVBO();
        this.gTexture.enableVertexPointerVBO();
        this.bTexture.enableVertexPointerVBO();
        LightMap.clearActiveClientTexture();
    }

    public void disableVertexPointers() {
        this.rTexture.disableVertexPointer();
        this.gTexture.disableVertexPointer();
        this.bTexture.disableVertexPointer();
        LightMap.clearActiveClientTexture();
    }

    @Deprecated
    private static void clearBindTexture2D() {
        if (RPLEConfig.Compat.FASTER_GL_STATE_TRACKING) {
            GL11.glBindTexture((int)3553, (int)0);
        }
    }

    @Deprecated
    private static void clearMatrixMode() {
        if (RPLEConfig.Compat.FASTER_GL_STATE_TRACKING) {
            GL11.glMatrixMode((int)extMatrixMode);
        }
    }

    @Deprecated
    private static void clearActiveTexture() {
        if (RPLEConfig.Compat.FASTER_GL_STATE_TRACKING) {
            GL13.glActiveTexture((int)33984);
        }
    }

    @Deprecated
    private static void clearActiveClientTexture() {
        if (RPLEConfig.Compat.FASTER_GL_STATE_TRACKING) {
            GL13.glClientActiveTexture((int)33984);
        }
    }

    @Generated
    private LightMap() {
    }
}

