/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.rple.internal.client.lightmap;

import com.falsepattern.falsetweaks.api.triangulator.VertexAPI;
import com.falsepattern.rple.api.common.color.ColorChannel;
import com.falsepattern.rple.internal.Compat;
import com.falsepattern.rple.internal.client.render.VertexConstants;
import com.falsepattern.rple.internal.common.config.RPLEConfig;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import lombok.Generated;
import org.lwjgl.opengl.ARBMultitexture;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;

public final class LightMapTexture {
    private static IntBuffer PIXEL_BUFFER;
    private static int FIXED_VERTEX_STRIDE;
    private static int SHADER_VERTEX_STRIDE;
    private final int textureID;
    private final int colorBitMask;
    private final int fixedTextureUnitBinding;
    private final int shaderTextureSamplerBinding;
    private final int shaderTextureCoordsBinding;
    private final int fixedVertexPosition;
    private final int shaderVertexPosition;

    public static LightMapTexture createLightMapTexture(ColorChannel channel) {
        int shaderVertexPosition;
        int fixedVertexPosition;
        int shaderTextureCoordsBinding;
        int shaderTextureSamplerBinding;
        int fixedTextureUnitBinding;
        int colorBitMask;
        if (PIXEL_BUFFER == null) {
            PIXEL_BUFFER = ByteBuffer.allocateDirect(1024).order(ByteOrder.nativeOrder()).asIntBuffer();
            FIXED_VERTEX_STRIDE = VertexAPI.recomputeVertexInfo((int)8, (int)4);
            SHADER_VERTEX_STRIDE = VertexAPI.recomputeVertexInfo((int)20, (int)4);
        }
        int textureID = GL11.glGenTextures();
        SlowGlStateTracker.pushTextureName();
        GL11.glBindTexture((int)3553, (int)textureID);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        SlowGlStateTracker.popTextureName();
        switch (channel) {
            default: {
                colorBitMask = -16711681;
                fixedTextureUnitBinding = 33985;
                shaderTextureSamplerBinding = 34025;
                shaderTextureCoordsBinding = 33985;
                fixedVertexPosition = VertexConstants.getRedIndexNoShader() * 2;
                shaderVertexPosition = VertexConstants.getRedIndexShader() * 2;
                break;
            }
            case GREEN_CHANNEL: {
                colorBitMask = -65281;
                fixedTextureUnitBinding = 33986;
                shaderTextureSamplerBinding = 34026;
                shaderTextureCoordsBinding = 33990;
                fixedVertexPosition = VertexConstants.getGreenIndexNoShader() * 2;
                shaderVertexPosition = VertexConstants.getGreenIndexShader() * 2;
                break;
            }
            case BLUE_CHANNEL: {
                colorBitMask = -256;
                fixedTextureUnitBinding = 33987;
                shaderTextureSamplerBinding = 34027;
                shaderTextureCoordsBinding = 33991;
                fixedVertexPosition = VertexConstants.getBlueIndexNoShader() * 2;
                shaderVertexPosition = VertexConstants.getBlueIndexShader() * 2;
            }
        }
        return new LightMapTexture(textureID, colorBitMask, fixedTextureUnitBinding, shaderTextureSamplerBinding, shaderTextureCoordsBinding, fixedVertexPosition, shaderVertexPosition);
    }

    public void update(int[] pixels) {
        PIXEL_BUFFER.clear();
        for (int i = 0; i < 256; ++i) {
            PIXEL_BUFFER.put(pixels[i] | this.colorBitMask);
        }
        PIXEL_BUFFER.flip();
        SlowGlStateTracker.pushTextureName();
        GL11.glBindTexture((int)3553, (int)this.textureID);
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)16, (int)16, (int)0, (int)32993, (int)5121, (IntBuffer)PIXEL_BUFFER);
        SlowGlStateTracker.popTextureName();
    }

    public void toggleEnabled(boolean enabled) {
        if (Compat.shadersEnabled()) {
            return;
        }
        SlowGlStateTracker.pushActiveTexture();
        GL13.glActiveTexture((int)this.fixedTextureUnitBinding);
        if (enabled) {
            GL11.glEnable((int)3553);
        } else {
            GL11.glDisable((int)3553);
        }
        SlowGlStateTracker.popActiveTexture();
    }

    public void bind() {
        SlowGlStateTracker.pushActiveTexture();
        if (Compat.shadersEnabled()) {
            GL13.glActiveTexture((int)this.shaderTextureSamplerBinding);
        } else {
            GL13.glActiveTexture((int)this.fixedTextureUnitBinding);
            GL11.glEnable((int)3553);
        }
        GL11.glBindTexture((int)3553, (int)this.textureID);
        SlowGlStateTracker.popActiveTexture();
    }

    public void unbind() {
        if (!Compat.shadersEnabled()) {
            SlowGlStateTracker.pushActiveTexture();
            GL13.glActiveTexture((int)this.fixedTextureUnitBinding);
            GL11.glDisable((int)3553);
            SlowGlStateTracker.popActiveTexture();
        }
    }

    public void resetScale() {
        SlowGlStateTracker.pushActiveTexture();
        if (Compat.shadersEnabled()) {
            GL13.glActiveTexture((int)this.shaderTextureCoordsBinding);
        } else {
            GL13.glActiveTexture((int)this.fixedTextureUnitBinding);
        }
        SlowGlStateTracker.pushMatrixMode();
        GL11.glMatrixMode((int)5890);
        GL11.glLoadIdentity();
        SlowGlStateTracker.popMatrixMode();
        SlowGlStateTracker.popActiveTexture();
    }

    public void rescale() {
        SlowGlStateTracker.pushActiveTexture();
        if (Compat.shadersEnabled()) {
            GL13.glActiveTexture((int)this.shaderTextureCoordsBinding);
        } else {
            GL13.glActiveTexture((int)this.fixedTextureUnitBinding);
            GL11.glEnable((int)3553);
        }
        SlowGlStateTracker.pushMatrixMode();
        GL11.glMatrixMode((int)5890);
        GL11.glLoadIdentity();
        GL11.glScalef((float)1.5259022E-5f, (float)1.5259022E-5f, (float)1.0f);
        GL11.glTranslatef((float)32767.0f, (float)32767.0f, (float)0.0f);
        SlowGlStateTracker.popMatrixMode();
        SlowGlStateTracker.popActiveTexture();
    }

    public void enableVertexPointer(ShortBuffer buffer) {
        SlowGlStateTracker.pushClientActiveTexture();
        if (Compat.shadersEnabled()) {
            GL13.glClientActiveTexture((int)this.shaderTextureCoordsBinding);
            buffer.position(this.shaderVertexPosition);
            GL11.glTexCoordPointer((int)2, (int)SHADER_VERTEX_STRIDE, (ShortBuffer)buffer);
        } else {
            GL13.glClientActiveTexture((int)this.fixedTextureUnitBinding);
            buffer.position(this.fixedVertexPosition);
            GL11.glTexCoordPointer((int)2, (int)FIXED_VERTEX_STRIDE, (ShortBuffer)buffer);
        }
        GL11.glEnableClientState((int)32888);
        SlowGlStateTracker.popClientActiveTexture();
    }

    public void enableVertexPointerVBO() {
        SlowGlStateTracker.pushClientActiveTexture();
        GL13.glClientActiveTexture((int)this.shaderTextureCoordsBinding);
        GL11.glTexCoordPointer((int)2, (int)5122, (int)SHADER_VERTEX_STRIDE, (long)((long)this.shaderVertexPosition * 2L));
        GL11.glEnableClientState((int)32888);
        SlowGlStateTracker.popClientActiveTexture();
    }

    public void disableVertexPointer() {
        SlowGlStateTracker.pushClientActiveTexture();
        if (Compat.shadersEnabled()) {
            GL13.glClientActiveTexture((int)this.shaderTextureCoordsBinding);
        } else {
            GL13.glClientActiveTexture((int)this.fixedTextureUnitBinding);
        }
        GL11.glDisableClientState((int)32888);
        SlowGlStateTracker.popClientActiveTexture();
    }

    public void setCoords(short block, short sky) {
        if (Compat.shadersEnabled()) {
            ARBMultitexture.glMultiTexCoord2sARB((int)this.shaderTextureCoordsBinding, (short)block, (short)sky);
        } else {
            ARBMultitexture.glMultiTexCoord2sARB((int)this.fixedTextureUnitBinding, (short)block, (short)sky);
        }
    }

    @Generated
    private LightMapTexture(int textureID, int colorBitMask, int fixedTextureUnitBinding, int shaderTextureSamplerBinding, int shaderTextureCoordsBinding, int fixedVertexPosition, int shaderVertexPosition) {
        this.textureID = textureID;
        this.colorBitMask = colorBitMask;
        this.fixedTextureUnitBinding = fixedTextureUnitBinding;
        this.shaderTextureSamplerBinding = shaderTextureSamplerBinding;
        this.shaderTextureCoordsBinding = shaderTextureCoordsBinding;
        this.fixedVertexPosition = fixedVertexPosition;
        this.shaderVertexPosition = shaderVertexPosition;
    }

    @Deprecated
    private static class SlowGlStateTracker {
        private static int lastTextureName = 0;
        private static int lastActiveTexture = 0;
        private static int lastClientActiveTexture = 0;
        private static int lastMatrixMode = 0;

        private SlowGlStateTracker() {
        }

        private static void pushTextureName() {
            if (!RPLEConfig.Compat.FASTER_GL_STATE_TRACKING) {
                lastTextureName = GL11.glGetInteger((int)32873);
            }
        }

        private static void popTextureName() {
            if (!RPLEConfig.Compat.FASTER_GL_STATE_TRACKING) {
                GL11.glBindTexture((int)3553, (int)lastTextureName);
            }
        }

        private static void pushActiveTexture() {
            if (!RPLEConfig.Compat.FASTER_GL_STATE_TRACKING) {
                lastActiveTexture = GL11.glGetInteger((int)34016);
            }
        }

        private static void popActiveTexture() {
            if (!RPLEConfig.Compat.FASTER_GL_STATE_TRACKING) {
                GL13.glActiveTexture((int)lastActiveTexture);
            }
        }

        private static void pushClientActiveTexture() {
            if (!RPLEConfig.Compat.FASTER_GL_STATE_TRACKING) {
                lastClientActiveTexture = GL11.glGetInteger((int)34017);
            }
        }

        private static void popClientActiveTexture() {
            if (!RPLEConfig.Compat.FASTER_GL_STATE_TRACKING) {
                GL13.glClientActiveTexture((int)lastClientActiveTexture);
            }
        }

        private static void pushMatrixMode() {
            if (!RPLEConfig.Compat.FASTER_GL_STATE_TRACKING) {
                lastMatrixMode = GL11.glGetInteger((int)2976);
            }
        }

        private static void popMatrixMode() {
            if (!RPLEConfig.Compat.FASTER_GL_STATE_TRACKING) {
                GL11.glMatrixMode((int)lastMatrixMode);
            }
        }
    }
}

