/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.rple.internal.common.config;

import com.falsepattern.lib.util.FileUtil;
import com.falsepattern.rple.internal.common.config.adapter.BlockReferenceJSONAdapter;
import com.falsepattern.rple.internal.common.config.adapter.ColorReferenceJSONAdapter;
import com.falsepattern.rple.internal.common.config.adapter.HexColorJSONAdapter;
import com.falsepattern.rple.internal.common.config.adapter.PaletteJSONAdapter;
import com.falsepattern.rple.internal.common.config.container.BlockColorConfig;
import com.falsepattern.rple.internal.common.config.container.BlockReference;
import com.falsepattern.rple.internal.common.config.container.ColorPalette;
import com.falsepattern.rple.internal.common.config.container.ColorReference;
import com.falsepattern.rple.internal.common.config.container.HexColor;
import com.falsepattern.rple.internal.common.util.LogHelper;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.Logger;

public final class ColorConfigLoader {
    private static final Logger LOG = LogHelper.createLogger("ColorConfigLoader");
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(ColorPalette.class, (Object)new PaletteJSONAdapter()).registerTypeAdapter(HexColor.class, (Object)new HexColorJSONAdapter()).registerTypeAdapter(BlockReference.class, (Object)new BlockReferenceJSONAdapter()).registerTypeAdapter(ColorReference.class, (Object)new ColorReferenceJSONAdapter()).create();
    private static final Path CONFIG_PATH = FileUtil.getMinecraftHome().toPath().resolve("config").resolve("rple");
    private static final File CONFIG_README_FILE = CONFIG_PATH.resolve("README.txt").toFile();
    private static final File GENERATED_CONFIG_FILE = CONFIG_PATH.resolve("generated_colors.json").toFile();
    private static final File CUSTOM_CONFIG_FILE = CONFIG_PATH.resolve("custom_colors.json").toFile();
    private static final String README_TEXT = "Copy the `generated_colors.json` to `custom_colors.json`.\n`generated_colors.json` is never read, only written to on startup.\n If `custom_colors.json` exists, it will be used to set the colors of any block configured in it.\n`custom_colors.json` does not act as an overlay, it acts as a definition.\nIf `custom_colors.json` does not have a block, it will not be configured.\nSome mods may be implementing their own color values, and as such configurations may be provided by their authors.";

    public static Gson colorConfigGSON() {
        return GSON;
    }

    public static void generateReadmeFile() {
        try {
            Files.createDirectories(CONFIG_PATH, new FileAttribute[0]);
            FileUtils.writeStringToFile((File)CONFIG_README_FILE, (String)README_TEXT);
        }
        catch (IOException e) {
            LOG.error("Failed to generate README.txt", (Throwable)e);
        }
    }

    public static void saveGeneratedConfig(BlockColorConfig config) throws IOException {
        String json = ColorConfigLoader.fromObjectToPrettyPrintJson(config);
        Files.createDirectories(CONFIG_PATH, new FileAttribute[0]);
        FileUtils.writeStringToFile((File)GENERATED_CONFIG_FILE, (String)json);
    }

    public static Optional<BlockColorConfig> loadCustomConfig() throws IOException {
        if (!CUSTOM_CONFIG_FILE.isFile()) {
            return Optional.empty();
        }
        String json = FileUtils.readFileToString((File)CUSTOM_CONFIG_FILE);
        try {
            BlockColorConfig config = (BlockColorConfig)GSON.fromJson(json, BlockColorConfig.class);
            return Optional.of(config);
        }
        catch (JsonSyntaxException e) {
            throw new IOException(e);
        }
    }

    public static String fromObjectToPrettyPrintJson(Object source) {
        StringWriter stringWriter = new StringWriter();
        JsonWriter jsonWriter = new JsonWriter((Writer)stringWriter);
        jsonWriter.setIndent("    ");
        GSON.toJson(source, source.getClass(), jsonWriter);
        return stringWriter.toString();
    }

    public static void logParsingError(String message, Object ... params) {
        LOG.warn(message, params);
    }

    @Generated
    private ColorConfigLoader() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

