/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.rple.internal.common.config;

import com.falsepattern.lib.config.Config;
import com.falsepattern.lib.config.ConfigurationManager;

public final class RPLEConfig {
    public static void poke() {
    }

    public static Class<?>[] configClasses() {
        return new Class[]{General.class, Debug.class, Compat.class, HD.class};
    }

    private static void init() {
        ConfigurationManager.initialize((a, b) -> {}, (Class[])RPLEConfig.configClasses());
    }

    static {
        RPLEConfig.init();
    }

    public static enum LogMode {
        CUSTOM,
        ALL,
        NONE;

    }

    @Config(modid="rple", category="hardcore_darkness")
    @Config.Synchronize
    public static final class HD {
        @Config.Name(value="mode")
        @Config.Comment(value={"Disabled: No hardcore darkness", "BlockOnly: No minimum block light, normal skylight", "DynamicMoonlight: No minimum block light, skylight is dependent on moon phase", "Both: No minimum sky & block light"})
        @Config.LangKey(value="config.rple.hd.mode")
        @Config.DefaultEnum(value="Disabled")
        public static Mode MODE;
        @Config.Name(value="darkNether")
        @Config.Comment(value={"Whether the Nether is also supposed to have its minimum light removed"})
        @Config.LangKey(value="config.rple.hd.darkNether")
        @Config.DefaultBoolean(value=true)
        public static boolean DARK_NETHER;
        @Config.Name(value="darkEnd")
        @Config.Comment(value={"Whether the End is also supposed to have its minimum light removed"})
        @Config.LangKey(value="config.rple.hd.darkEnd")
        @Config.DefaultBoolean(value=false)
        public static boolean DARK_END;
        @Config.Name(value="gammaOverride")
        @Config.Comment(value={"Setting this to something other than -1 will lock the gamma config settings to that value. (0.0 - 1.0)"})
        @Config.LangKey(value="config.rple.hd.gamma")
        @Config.RangeDouble(min=-1.0, max=1.0)
        @Config.DefaultDouble(value=0.0)
        public static double GAMMA_OVERRIDE;
        @Config.Name(value="moonLightList")
        @Config.Comment(value={"In mode 2 this list defines how much skylight there is when 0%/25%/50%/75%/100% of the moon is visible. (Values go from 0 (Total Darkness) to 1 (Total Brightness))."})
        @Config.LangKey(value="config.rple.hd.moonLight")
        @Config.RangeDouble(min=0.0, max=1.0)
        @Config.ListFixedLength
        @Config.DefaultDoubleList(value={0.0, 0.075, 0.15, 0.225, 0.3})
        public static double[] MOON_LIGHT_LIST;
        @Config.Name(value="dimensionBlacklist")
        @Config.Comment(value={"A list of dimension ids in which Hardcore Darkness will be completely disabled."})
        @Config.DefaultIntList(value={})
        @Config.ListMaxLength(value=0x7FFFFFFF)
        public static int[] DIMENSION_BLACKLIST;

        static {
            RPLEConfig.poke();
        }

        public static enum Mode {
            Disabled,
            BlockOnly,
            DynamicMoonlight,
            Both;

        }
    }

    @Config(modid="rple", category="debug")
    public static final class Debug {
        @Config.Name(value="rgbLightOverlay")
        @Config.Comment(value={"Toggles rendering a light level debug overlay in the world."})
        @Config.LangKey(value="config.rple.debug.rgbLightOverlay")
        @Config.DefaultBoolean(value=false)
        public static Boolean RGB_LIGHT_OVERLAY;
        @Config.Name(value="logMode")
        @Config.Comment(value={"Determines how the debug logging configs a treated.", "[CUSTOM] User defined configs are respected", "[ALL] Forcibly enables all debug logging. (Most Verbose)", "[NONE] Fully disables debug logging. (Best Performance)"})
        @Config.LangKey(value="config.rple.debug.logMode")
        @Config.DefaultEnum(value="CUSTOM")
        public static LogMode DEBUG_LOG_MODE;
        @Config.Name(value="forceLogToConsole")
        @Config.Comment(value={"Forces logs at levels [DEBUG] and [TRACE] to appear in the console.", "Usually, these will only appear in your 'fml-client-*.log' file."})
        @Config.LangKey(value="config.rple.debug.forceLogToConsole")
        @Config.RequiresMcRestart
        @Config.DefaultBoolean(value=false)
        public static boolean DEBUG_FORCE_LOG_TO_CONSOLE;
        @Config.Name(value="asmTransformer")
        @Config.Comment(value={"Toggles ASM transformation logging."})
        @Config.LangKey(value="config.rple.debug.asmTransformer")
        @Config.RequiresMcRestart
        @Config.DefaultBoolean(value=false)
        public static boolean DEBUG_ASM_TRANSFORMER;
        @Config.Name(value="cookieMonster")
        @Config.Comment(value={"Toggles the logging of the Cookie Monster class, which handles the 'packing' of brightness values for rendering."})
        @Config.LangKey(value="config.rple.debug.cookieMonster")
        @Config.DefaultBoolean(value=false)
        public static boolean DEBUG_COOKIE_MONSTER;
        @Config.Name(value="classBlockList")
        @Config.Comment(value={"Toggles the logging of classes being blocked or permitted to handle cookie brightness.", "This relates to the colorization of entities and particles."})
        @Config.LangKey(value="config.rple.debug.classBlockList")
        @Config.DefaultBoolean(value=false)
        public static boolean DEBUG_CLASS_BLOCK_LIST;

        static {
            RPLEConfig.poke();
        }
    }

    @Config(modid="rple", category="compat")
    public static final class Compat {
        @Config.Name(value="weakerProjectRedMixins")
        @Config.Comment(value={"Set this to false if running on modern java"})
        @Config.LangKey(value="config.rple.compat.weakerProjectRed")
        @Config.RequiresMcRestart
        @Config.DefaultBoolean(value=true)
        public static boolean WEAKER_PROJECTRED_MIXINS;
        @Config.Name(value="fasterGlStateTracking")
        @Config.Comment(value={"Faster but potentially less compatible tracking for GL State."})
        @Config.LangKey(value="config.rple.compat.fasterGlStateTracking")
        @Config.RequiresMcRestart
        @Config.DefaultBoolean(value=true)
        public static boolean FASTER_GL_STATE_TRACKING;

        static {
            RPLEConfig.poke();
        }
    }

    @Config(modid="rple")
    public static final class General {
        @Config.Name(value="craftableLamps")
        @Config.Comment(value={"Set this to true if you want to enable the default lamps.", "(Based on ProjectRed's lamps, but much more optimized)"})
        @Config.LangKey(value="config.rple.general.craftableLamps")
        @Config.RequiresMcRestart
        @Config.DefaultBoolean(value=true)
        public static boolean CRAFTABLE_LAMPS;

        static {
            RPLEConfig.poke();
        }
    }
}

