/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.rple.internal.common.config.container;

import com.falsepattern.rple.api.common.color.RPLENamedColor;
import com.falsepattern.rple.internal.common.config.container.HexColor;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.UnmodifiableView;

public final class ColorPalette {
    private final LinkedHashMap<String, HexColor> colors;

    public ColorPalette() {
        this(new LinkedHashMap<String, HexColor>());
    }

    public ColorPalette(LinkedHashMap<String, HexColor> colors) {
        this.colors = colors;
        this.colors.entrySet().removeIf(c -> !ColorPalette.isValidPaletteColor((String)c.getKey(), (HexColor)c.getValue()));
    }

    public void addPaletteColor(RPLENamedColor color) {
        if (color == null) {
            return;
        }
        String paletteColorName = color.paletteColorName();
        if (this.colors.containsKey(paletteColorName)) {
            return;
        }
        HexColor paletteColor = new HexColor(color.rgb16());
        if (ColorPalette.isValidPaletteColor(paletteColorName, paletteColor)) {
            this.colors.put(paletteColorName, paletteColor);
        }
    }

    public void addColor(String name, String colorHex) {
        HexColor color = new HexColor(colorHex);
        if (ColorPalette.isValidPaletteColor(name, color)) {
            this.colors.put(name, new HexColor(colorHex));
        }
    }

    public @UnmodifiableView Map<String, HexColor> colors() {
        return Collections.unmodifiableMap(this.colors);
    }

    public Optional<HexColor> colour(String colorName) {
        return Optional.ofNullable(this.colors.get(colorName));
    }

    public void reset() {
        this.colors.clear();
    }

    public int hashCode() {
        return this.colors.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ColorPalette)) {
            return false;
        }
        ColorPalette other = (ColorPalette)obj;
        return this.colors.equals(other.colors);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, HexColor> color : this.colors.entrySet()) {
            sb.append(color.getKey()).append(": ").append(color.getValue()).append("\n");
        }
        return sb.toString();
    }

    public static boolean isValidPaletteColor(String colorName, HexColor color) {
        if (colorName == null) {
            return false;
        }
        if (color == null) {
            return false;
        }
        if (!ColorPalette.isValidPaletteColorName(colorName)) {
            return false;
        }
        return color.isValid();
    }

    public static boolean isValidPaletteColorName(String colorName) {
        if (colorName == null) {
            return false;
        }
        return !colorName.toLowerCase().startsWith("0x");
    }
}

