/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.rple.internal.common.world;

import com.falsepattern.lumi.api.LumiAPI;
import com.falsepattern.lumi.api.chunk.LumiChunk;
import com.falsepattern.lumi.api.chunk.LumiChunkRoot;
import com.falsepattern.lumi.api.lighting.LightType;
import com.falsepattern.lumi.api.lighting.LumiLightingEngine;
import com.falsepattern.lumi.api.world.LumiWorld;
import com.falsepattern.rple.api.client.ClientColorHelper;
import com.falsepattern.rple.api.common.block.RPLEBlock;
import com.falsepattern.rple.api.common.color.ColorChannel;
import com.falsepattern.rple.internal.common.cache.RPLEBlockStorageRoot;
import com.falsepattern.rple.internal.common.chunk.RPLEChunk;
import com.falsepattern.rple.internal.common.chunk.RPLEChunkRoot;
import com.falsepattern.rple.internal.common.chunk.RPLESubChunk;
import com.falsepattern.rple.internal.common.chunk.RPLESubChunkRoot;
import com.falsepattern.rple.internal.common.world.RPLEWorld;
import com.falsepattern.rple.internal.common.world.RPLEWorldRoot;
import lombok.Generated;
import net.minecraft.block.Block;
import net.minecraft.profiler.Profiler;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RPLEWorldContainer
implements RPLEWorld {
    private static final String RED_WORLD_ID = "rple_" + (Object)((Object)ColorChannel.RED_CHANNEL) + "_world";
    private static final String GREEN_WORLD_ID = "rple_" + (Object)((Object)ColorChannel.GREEN_CHANNEL) + "_world";
    private static final String BLUE_WORLD_ID = "rple_" + (Object)((Object)ColorChannel.BLUE_CHANNEL) + "_world";
    private final ColorChannel channel;
    private final World base;
    private final RPLEWorldRoot worldRoot;
    private final RPLEBlockStorageRoot blockStorageRoot;
    private final LumiLightingEngine lightingEngine;

    public RPLEWorldContainer(ColorChannel channel, World base, RPLEWorldRoot root, Profiler profiler) {
        this.channel = channel;
        this.base = base;
        this.worldRoot = root;
        this.blockStorageRoot = root;
        this.lightingEngine = LumiAPI.provideLightingEngine((LumiWorld)this, (Profiler)profiler);
    }

    @Override
    @NotNull
    public ColorChannel rple$channel() {
        return this.channel;
    }

    @Override
    @NotNull
    public RPLEWorldRoot lumi$root() {
        return this.worldRoot;
    }

    @Override
    public RPLEWorld getCloneForChunkCache(RPLEBlockStorageRoot chunkCache) {
        return new RPLEWorldContainer(this.channel, this.base, this.worldRoot, chunkCache, this.lightingEngine);
    }

    @NotNull
    public String lumi$worldID() {
        switch (this.channel) {
            default: {
                return RED_WORLD_ID;
            }
            case GREEN_CHANNEL: {
                return GREEN_WORLD_ID;
            }
            case BLUE_CHANNEL: 
        }
        return BLUE_WORLD_ID;
    }

    @Override
    @NotNull
    public RPLEChunk lumi$wrap(@NotNull Chunk chunkBase) {
        RPLEChunkRoot chunkRoot = (RPLEChunkRoot)chunkBase;
        return chunkRoot.rple$chunk(this.channel);
    }

    @Override
    @NotNull
    public RPLESubChunk lumi$wrap(@NotNull ExtendedBlockStorage subChunkBase) {
        RPLESubChunkRoot chunkSubRoot = (RPLESubChunkRoot)subChunkBase;
        return chunkSubRoot.rple$subChunk(this.channel);
    }

    @Override
    @Nullable
    public RPLEChunk lumi$getChunkFromBlockPosIfExists(int posX, int posZ) {
        LumiChunkRoot lumiChunkRoot = this.blockStorageRoot.lumi$getChunkRootFromBlockPosIfExists(posX, posZ);
        if (!(lumiChunkRoot instanceof RPLEChunkRoot)) {
            return null;
        }
        RPLEChunkRoot chunkRoot = (RPLEChunkRoot)lumiChunkRoot;
        return chunkRoot.rple$chunk(this.channel);
    }

    @Override
    @Nullable
    public RPLEChunk lumi$getChunkFromChunkPosIfExists(int chunkPosX, int chunkPosZ) {
        LumiChunkRoot lumiChunkRoot = this.blockStorageRoot.lumi$getChunkRootFromChunkPosIfExists(chunkPosX, chunkPosZ);
        if (!(lumiChunkRoot instanceof RPLEChunkRoot)) {
            return null;
        }
        RPLEChunkRoot chunkRoot = (RPLEChunkRoot)lumiChunkRoot;
        return chunkRoot.rple$chunk(this.channel);
    }

    @NotNull
    public LumiLightingEngine lumi$lightingEngine() {
        return this.lightingEngine;
    }

    public void lumi$setLightValue(@Nullable LumiChunk chunk, @NotNull LightType lightType, int posX, int posY, int posZ, int lightValue) {
        if (chunk != null) {
            int subChunkPosX = posX & 0xF;
            int subChunkPosZ = posZ & 0xF;
            chunk.lumi$setLightValue(lightType, subChunkPosX, posY, subChunkPosZ, lightValue);
        }
    }

    public void lumi$setBlockLightValue(@Nullable LumiChunk chunk, int posX, int posY, int posZ, int lightValue) {
        if (chunk != null) {
            int subChunkPosX = posX & 0xF;
            int subChunkPosZ = posZ & 0xF;
            chunk.lumi$setBlockLightValue(subChunkPosX, posY, subChunkPosZ, lightValue);
        }
    }

    public void lumi$setSkyLightValue(@Nullable LumiChunk chunk, int posX, int posY, int posZ, int lightValue) {
        if (!this.lumi$root().lumi$hasSky()) {
            return;
        }
        if (chunk != null) {
            int subChunkPosX = posX & 0xF;
            int subChunkPosZ = posZ & 0xF;
            chunk.lumi$setSkyLightValue(subChunkPosX, posY, subChunkPosZ, lightValue);
        }
    }

    @NotNull
    public String lumi$blockStorageID() {
        return this.lumi$worldID();
    }

    @Override
    @NotNull
    public RPLEWorld lumi$world() {
        return this;
    }

    public int lumi$getBrightness(@Nullable LumiChunk chunk, @NotNull LightType lightType, int posX, int posY, int posZ) {
        switch (lightType) {
            case BLOCK_LIGHT_TYPE: {
                return this.lumi$getBrightness(chunk, posX, posY, posZ);
            }
            case SKY_LIGHT_TYPE: {
                return this.lumi$getSkyLightValue(chunk, posX, posY, posZ);
            }
        }
        return 0;
    }

    public int lumi$getBrightness(@Nullable LumiChunk chunk, int posX, int posY, int posZ) {
        if (chunk != null) {
            int subChunkPosX = posX & 0xF;
            int subChunkPosZ = posZ & 0xF;
            return chunk.lumi$getBrightness(subChunkPosX, posY, subChunkPosZ);
        }
        int blockBrightness = this.lumi$getBlockBrightness(posX, posY, posZ);
        return Math.max(blockBrightness, LightType.BLOCK_LIGHT_TYPE.defaultLightValue());
    }

    public int lumi$getLightValue(@Nullable LumiChunk chunk, int posX, int posY, int posZ) {
        if (chunk != null) {
            int subChunkPosX = posX & 0xF;
            int subChunkPosZ = posZ & 0xF;
            return chunk.lumi$getLightValue(subChunkPosX, posY, subChunkPosZ);
        }
        return LightType.maxBaseLightValue();
    }

    public int lumi$getLightValue(@Nullable LumiChunk chunk, @NotNull LightType lightType, int posX, int posY, int posZ) {
        if (chunk != null) {
            int subChunkPosX = posX & 0xF;
            int subChunkPosZ = posZ & 0xF;
            return chunk.lumi$getLightValue(lightType, subChunkPosX, posY, subChunkPosZ);
        }
        switch (lightType) {
            default: {
                return LightType.BLOCK_LIGHT_TYPE.defaultLightValue();
            }
            case SKY_LIGHT_TYPE: 
        }
        if (this.lumi$root().lumi$hasSky()) {
            return LightType.SKY_LIGHT_TYPE.defaultLightValue();
        }
        return 0;
    }

    public int lumi$getBlockLightValue(@Nullable LumiChunk chunk, int posX, int posY, int posZ) {
        if (chunk != null) {
            int subChunkPosX = posX & 0xF;
            int subChunkPosZ = posZ & 0xF;
            return chunk.lumi$getBlockLightValue(subChunkPosX, posY, subChunkPosZ);
        }
        return LightType.BLOCK_LIGHT_TYPE.defaultLightValue();
    }

    public int lumi$getSkyLightValue(@Nullable LumiChunk chunk, int posX, int posY, int posZ) {
        if (!this.lumi$root().lumi$hasSky()) {
            return 0;
        }
        if (chunk != null) {
            int subChunkPosX = posX & 0xF;
            int subChunkPosZ = posZ & 0xF;
            return chunk.lumi$getSkyLightValue(subChunkPosX, posY, subChunkPosZ);
        }
        return LightType.SKY_LIGHT_TYPE.defaultLightValue();
    }

    public int lumi$getBlockBrightness(int posX, int posY, int posZ) {
        Block blockBase = this.blockStorageRoot.lumi$getBlock(posX, posY, posZ);
        int blockMeta = this.blockStorageRoot.lumi$getBlockMeta(posX, posY, posZ);
        return this.lumi$getBlockBrightness(blockBase, blockMeta, posX, posY, posZ);
    }

    public int lumi$getBlockOpacity(int posX, int posY, int posZ) {
        Block blockBase = this.blockStorageRoot.lumi$getBlock(posX, posY, posZ);
        int blockMeta = this.blockStorageRoot.lumi$getBlockMeta(posX, posY, posZ);
        return this.lumi$getBlockOpacity(blockBase, blockMeta, posX, posY, posZ);
    }

    public int lumi$getBlockBrightness(@NotNull Block blockBase, int blockMeta, int posX, int posY, int posZ) {
        RPLEBlock block = RPLEBlock.of(blockBase);
        return this.channel.componentFromColor(block.rple$getRawBrightnessColor((IBlockAccess)this.base, blockMeta, posX, posY, posZ));
    }

    public int lumi$getBlockOpacity(@NotNull Block blockBase, int blockMeta, int posX, int posY, int posZ) {
        RPLEBlock block = RPLEBlock.of(blockBase);
        return this.channel.componentFromColor(block.rple$getRawOpacityColor((IBlockAccess)this.base, blockMeta, posX, posY, posZ));
    }

    @Override
    public int rple$getChannelBrightnessForTessellator(@Nullable RPLEChunk chunk, int posX, int posY, int posZ, int minBlockLight) {
        int blockLightValue = this.rple$getChannelLightValueForRender(chunk, LightType.BLOCK_LIGHT_TYPE, posX, posY, posZ);
        blockLightValue = Math.max(blockLightValue, minBlockLight);
        int skyLightValue = this.rple$getChannelLightValueForRender(chunk, LightType.SKY_LIGHT_TYPE, posX, posY, posZ);
        return ClientColorHelper.vanillaFromBlockSky4Bit(blockLightValue, skyLightValue);
    }

    @Override
    public int rple$getChannelLightValueForRender(@Nullable RPLEChunk chunk, @NotNull LightType lightType, int posX, int posY, int posZ) {
        if (lightType == LightType.SKY_LIGHT_TYPE && !this.blockStorageRoot.lumi$hasSky()) {
            return 0;
        }
        if (posY < 0) {
            posY = 0;
        } else if (posY > 255) {
            return lightType.defaultLightValue();
        }
        if (posX < -30000000 || posX >= 30000000) {
            return lightType.defaultLightValue();
        }
        if (posZ < -30000000 || posZ >= 30000000) {
            return lightType.defaultLightValue();
        }
        Block block = this.getBlock(chunk, posX, posY, posZ);
        if (block.func_149710_n()) {
            int lightValue = 0;
            lightValue = Math.max(lightValue, this.getNeighborLightValue(chunk, lightType, posX, posY, posZ, ForgeDirection.UP));
            lightValue = Math.max(lightValue, this.getNeighborLightValue(chunk, lightType, posX, posY, posZ, ForgeDirection.NORTH));
            lightValue = Math.max(lightValue, this.getNeighborLightValue(chunk, lightType, posX, posY, posZ, ForgeDirection.SOUTH));
            lightValue = Math.max(lightValue, this.getNeighborLightValue(chunk, lightType, posX, posY, posZ, ForgeDirection.WEST));
            lightValue = Math.max(lightValue, this.getNeighborLightValue(chunk, lightType, posX, posY, posZ, ForgeDirection.EAST));
            return lightValue;
        }
        return this.lumi$getBrightness(chunk, lightType, posX, posY, posZ);
    }

    private Block getBlock(@Nullable RPLEChunk chunk, int posX, int posY, int posZ) {
        if (chunk != null) {
            int subChunkPosX = posX & 0xF;
            int subChunkPosZ = posZ & 0xF;
            RPLEChunkRoot rootChunk = chunk.lumi$root();
            return rootChunk.lumi$getBlock(subChunkPosX, posY, subChunkPosZ);
        }
        return this.blockStorageRoot.lumi$getBlock(posX, posY, posZ);
    }

    private int getNeighborLightValue(@Nullable RPLEChunk chunk, LightType lightType, int posX, int posY, int posZ, ForgeDirection direction) {
        int chunkXPre = posX >> 4;
        int chunkZPre = posZ >> 4;
        posY += direction.offsetY;
        int chunkXPost = (posX += direction.offsetX) >> 4;
        int chunkZPost = (posZ += direction.offsetZ) >> 4;
        if (chunkXPre != chunkXPost || chunkZPre != chunkZPost) {
            chunk = this.lumi$getChunkFromBlockPosIfExists(posX, posZ);
        }
        return this.lumi$getBrightness(chunk, lightType, posX, posY, posZ);
    }

    @Generated
    private RPLEWorldContainer(ColorChannel channel, World base, RPLEWorldRoot worldRoot, RPLEBlockStorageRoot blockStorageRoot, LumiLightingEngine lightingEngine) {
        this.channel = channel;
        this.base = base;
        this.worldRoot = worldRoot;
        this.blockStorageRoot = blockStorageRoot;
        this.lightingEngine = lightingEngine;
    }
}

