/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.rple.internal.mixin.mixins.client.architecturecraft;

import com.falsepattern.lib.util.MathUtil;
import com.falsepattern.rple.api.client.ClientColorHelper;
import com.falsepattern.rple.api.client.CookieMonster;
import com.falsepattern.rple.internal.mixin.interfaces.architecturecraft.IVector3Mixin;
import gcewing.architecture.BaseRenderTarget;
import gcewing.architecture.BaseUtils;
import gcewing.architecture.BaseWorldRenderTarget;
import gcewing.architecture.BlockPos;
import gcewing.architecture.Vector3;
import net.minecraft.block.Block;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={BaseWorldRenderTarget.class}, remap=false)
public abstract class BaseWorldRenderTargetMixin
extends BaseRenderTarget {
    @Shadow
    protected IBlockAccess world;
    @Shadow
    protected BlockPos blockPos;
    @Shadow
    protected Block block;

    @Shadow
    protected abstract void setLight(float var1, int var2);

    public BaseWorldRenderTargetMixin(double posX, double posY, double posZ, IIcon iIcon) {
        super(posX, posY, posZ, iIcon);
    }

    @Overwrite
    protected void aoLightVertex(Vector3 rawPos) {
        int brightnessCookie;
        IVector3Mixin vertexPos = (IVector3Mixin)rawPos;
        IVector3Mixin normal = (IVector3Mixin)this.normal;
        double bR = 0.0;
        double bG = 0.0;
        double bB = 0.0;
        double sR = 0.0;
        double sG = 0.0;
        double sB = 0.0;
        double ao = 0.0;
        double totalMultiplier = 0.0;
        double offsetX = vertexPos.rple$posX() + 0.5 * normal.rple$posX();
        double offsetY = vertexPos.rple$posY() + 0.5 * normal.rple$posY();
        double offsetZ = vertexPos.rple$posZ() + 0.5 * normal.rple$posZ();
        for (int X = -1; X <= 1; X += 2) {
            for (int Y = -1; Y <= 1; Y += 2) {
                for (int Z = -1; Z <= 1; Z += 2) {
                    int brightnessCookie2;
                    double dZ;
                    double dY;
                    int x = BaseUtils.ifloor((double)(offsetX + 0.5 * (double)X));
                    int y = BaseUtils.ifloor((double)(offsetY + 0.5 * (double)Y));
                    int z = BaseUtils.ifloor((double)(offsetZ + 0.5 * (double)Z));
                    BlockPos pos = new BlockPos(x, y, z);
                    double dX = X < 0 ? (double)(x + 1) - (offsetX - 0.5) : offsetX + 0.5 - (double)x;
                    double lightMultiplier = dX * (dY = Y < 0 ? (double)(y + 1) - (offsetY - 0.5) : offsetY + 0.5 - (double)y) * (dZ = Z < 0 ? (double)(z + 1) - (offsetZ - 0.5) : offsetZ + 0.5 - (double)z);
                    if (!(lightMultiplier > 0.0)) continue;
                    try {
                        brightnessCookie2 = this.block.func_149677_c(this.world, pos.x, pos.y, pos.z);
                    }
                    catch (RuntimeException var38) {
                        System.out.printf("BaseWorldRenderTarget.aoLightVertex: getMixedBrightnessForBlock(%s) with weight %s for block at %s: %s\n", pos, lightMultiplier, this.blockPos, var38);
                        System.out.printf("BaseWorldRenderTarget.aoLightVertex: v = %s n = %s\n", vertexPos, normal);
                        throw var38;
                    }
                    float aoRaw = pos.equals(this.blockPos) ? 1.0f : this.world.func_147439_a(pos.x, pos.y, pos.z).func_149685_I();
                    long brightness = CookieMonster.RGB64FromCookie(brightnessCookie2);
                    if (brightness != 0L) {
                        int r = ClientColorHelper.vanillaFromRGB64Red(brightness);
                        int g = ClientColorHelper.vanillaFromRGB64Green(brightness);
                        int b = ClientColorHelper.vanillaFromRGB64Blue(brightness);
                        double rbR = BaseWorldRenderTargetMixin.scalarBlock(r);
                        double rbG = BaseWorldRenderTargetMixin.scalarBlock(g);
                        double rbB = BaseWorldRenderTargetMixin.scalarBlock(b);
                        double rsR = BaseWorldRenderTargetMixin.scalarSky(r);
                        double rsG = BaseWorldRenderTargetMixin.scalarSky(g);
                        double rsB = BaseWorldRenderTargetMixin.scalarSky(b);
                        bR += lightMultiplier * rbR;
                        bG += lightMultiplier * rbG;
                        bB += lightMultiplier * rbB;
                        sR += lightMultiplier * rsR;
                        sG += lightMultiplier * rsG;
                        sB += lightMultiplier * rsB;
                        totalMultiplier += lightMultiplier;
                    }
                    ao += lightMultiplier * (double)aoRaw;
                }
            }
        }
        if (totalMultiplier > 0.0) {
            double inverseMul = 1.0 / totalMultiplier;
            int red = BaseWorldRenderTargetMixin.scalarsToBrightness(bR *= inverseMul, sR *= inverseMul);
            int green = BaseWorldRenderTargetMixin.scalarsToBrightness(bG *= inverseMul, sG *= inverseMul);
            int blue = BaseWorldRenderTargetMixin.scalarsToBrightness(bB *= inverseMul, sB *= inverseMul);
            long rgb64 = ClientColorHelper.RGB64FromVanillaRGB(red, green, blue);
            brightnessCookie = CookieMonster.cookieFromRGB64(rgb64);
        } else {
            brightnessCookie = this.block.func_149677_c(this.world, this.blockPos.x, this.blockPos.y, this.blockPos.z);
        }
        this.setLight(this.shade * (float)ao, brightnessCookie);
    }

    private static double scalarBlock(int brightness) {
        return (double)ClientColorHelper.block8BitFromVanilla(brightness) / 240.0;
    }

    private static double scalarSky(int brightness) {
        return (double)ClientColorHelper.sky8BitFromVanilla(brightness) / 240.0;
    }

    private static int scalarsToBrightness(double block, double sky) {
        block = MathUtil.clamp((double)block, (double)0.0, (double)1.0) * 240.0;
        sky = MathUtil.clamp((double)sky, (double)0.0, (double)1.0) * 240.0;
        int iBlock = (int)block;
        int iSky = (int)sky;
        return ClientColorHelper.vanillaFromBlockSky8Bit(iBlock, iSky);
    }
}

