/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.rple.internal.mixin.mixins.client.betterfoliage;

import com.falsepattern.rple.api.client.ClientColorHelper;
import com.falsepattern.rple.api.client.CookieMonster;
import mods.octarinecore.client.render.PixelFormat;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;

@Mixin(value={PixelFormat.class})
public abstract class PixelFormatMixin {
    @Overwrite(remap=false)
    public static final int brMul(int $receiver, float f) {
        return ClientColorHelper.cookieMul($receiver, f);
    }

    @Overwrite(remap=false)
    public static final int brSum(Float multiplier, int[] brightness) {
        long tmp;
        int len = brightness.length;
        switch (len) {
            case 0: {
                tmp = 0L;
                break;
            }
            case 1: {
                tmp = CookieMonster.RGB64FromCookie(brightness[0]);
                break;
            }
            case 2: {
                tmp = ClientColorHelper.RGB64Average(CookieMonster.RGB64FromCookie(brightness[0]), CookieMonster.RGB64FromCookie(brightness[1]), false);
                break;
            }
            case 4: {
                tmp = ClientColorHelper.RGB64Average(CookieMonster.RGB64FromCookie(brightness[0]), CookieMonster.RGB64FromCookie(brightness[1]), CookieMonster.RGB64FromCookie(brightness[2]), CookieMonster.RGB64FromCookie(brightness[3]), false);
                break;
            }
            default: {
                long[] rgb64Bright = new long[len];
                for (int i = 0; i < len; ++i) {
                    rgb64Bright[i] = CookieMonster.RGB64FromCookie(brightness[i]);
                }
                tmp = ClientColorHelper.RGB64Average(rgb64Bright, len, false);
            }
        }
        if (multiplier != null) {
            tmp = ClientColorHelper.RGB64Mul(tmp, multiplier.floatValue());
        }
        return CookieMonster.cookieFromRGB64(tmp);
    }

    @Overwrite(remap=false)
    public static final int brWeighted(int br1, float weight1, int br2, float weight2) {
        return ClientColorHelper.cookieMixAOBrightness(br1, br2, weight1, weight2);
    }
}

