/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.rple.internal.proxy;

import com.falsepattern.falsetweaks.api.dynlights.DynamicLightsDriver;
import com.falsepattern.falsetweaks.api.dynlights.FTDynamicLights;
import com.falsepattern.falsetweaks.modules.dynlights.base.OffhandMod;
import com.falsepattern.rple.api.common.ServerColorHelper;
import com.falsepattern.rple.api.common.block.RPLEBlock;
import com.falsepattern.rple.api.common.color.DefaultColor;
import com.falsepattern.rple.api.common.color.LightValueColor;
import com.falsepattern.rple.api.common.entity.RPLECustomEntityBrightness;
import com.falsepattern.rple.api.common.event.EntityColorRegistrationEvent;
import com.falsepattern.rple.api.common.event.ItemColorRegistrationEvent;
import com.falsepattern.rple.api.common.item.RPLECustomItemBrightness;
import com.falsepattern.rple.internal.HardcoreDarkness;
import com.falsepattern.rple.internal.client.dynlights.ColorDynamicLights;
import com.falsepattern.rple.internal.client.lamp.LampRenderer;
import com.falsepattern.rple.internal.client.lightmap.LightMapPipeline;
import com.falsepattern.rple.internal.client.render.VertexConstants;
import com.falsepattern.rple.internal.proxy.CommonProxy;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import lombok.Generated;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public final class ClientProxy
extends CommonProxy {
    @Override
    public void preInit(FMLPreInitializationEvent evt) {
        super.preInit(evt);
        VertexConstants.initVertexConstants();
        FMLCommonHandler.instance().bus().register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)HardcoreDarkness.INSTANCE);
    }

    @Override
    public void init(FMLInitializationEvent evt) {
        super.init(evt);
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new LampRenderer());
        LightMapPipeline.lightMapPipeline().registerLightMapProviders();
        FTDynamicLights.registerBackend((DynamicLightsDriver)ColorDynamicLights.INSTANCE, (int)500);
    }

    @SubscribeEvent
    public void handleItemColors(ItemColorRegistrationEvent e) {
        e.registry().registerItemColorCallback(stack -> {
            short c;
            Item item = stack.func_77973_b();
            if (item instanceof RPLECustomItemBrightness && (c = ((RPLECustomItemBrightness)item).rple$getCustomBrightnessColor(stack)) != -1) {
                return c;
            }
            if (item == Items.field_151129_at) {
                return RPLEBlock.of(Blocks.field_150353_l).rple$getBrightnessColor();
            }
            if (item == Items.field_151072_bj || item == Items.field_151065_br) {
                return DefaultColor.DIM_ORANGE.rgb16();
            }
            if (item == Items.field_151114_aO) {
                return DefaultColor.DIM_YELLOW.rgb16();
            }
            if (item == Items.field_151064_bs) {
                return DefaultColor.DIM_RED.rgb16();
            }
            if (item == Items.field_151156_bN) {
                return RPLEBlock.of((Block)Blocks.field_150461_bJ).rple$getBrightnessColor();
            }
            return -1;
        }, 0);
    }

    @SubscribeEvent
    public void handleEntityColors(EntityColorRegistrationEvent e) {
        e.registry().registerEntityColorCallback(entity -> {
            EntityCreeper entityCreeper;
            short c;
            boolean isHand;
            boolean bl = isHand = entity == Minecraft.func_71410_x().field_71451_h;
            if (isHand && !FTDynamicLights.isDynamicHandLight() || !isHand && !FTDynamicLights.isDynamicEntityLight()) {
                return LightValueColor.LIGHT_VALUE_0.rgb16();
            }
            if (entity instanceof RPLECustomEntityBrightness && (c = ((RPLECustomEntityBrightness)entity).rple$getCustomBrightnessColor()) != -1) {
                return c;
            }
            if (entity instanceof EntityItem) {
                EntityItem entityItem = (EntityItem)entity;
                ItemStack itemStack = ColorDynamicLights.getItemStack(entityItem);
                return ColorDynamicLights.getLightLevel(itemStack);
            }
            if (entity.func_70027_ad()) {
                return RPLEBlock.of((Block)Blocks.field_150480_ab).rple$getBrightnessColor();
            }
            if (entity instanceof EntityFireball) {
                return RPLEBlock.of((Block)Blocks.field_150480_ab).rple$getBrightnessColor();
            }
            if (entity instanceof EntityTNTPrimed) {
                return RPLEBlock.of((Block)Blocks.field_150480_ab).rple$getBrightnessColor();
            }
            if (entity instanceof EntityBlaze) {
                EntityBlaze entityBlaze = (EntityBlaze)entity;
                return entityBlaze.func_70845_n() ? RPLEBlock.of((Block)Blocks.field_150480_ab).rple$getBrightnessColor() : RPLEBlock.of(Blocks.field_150353_l).rple$getBrightnessColor();
            }
            if (entity instanceof EntityMagmaCube) {
                EntityMagmaCube emc = (EntityMagmaCube)entity;
                return (double)emc.field_70811_b > 0.6 ? RPLEBlock.of((Block)Blocks.field_150480_ab).rple$getBrightnessColor() : RPLEBlock.of(Blocks.field_150353_l).rple$getBrightnessColor();
            }
            if (entity instanceof EntityCreeper && (entityCreeper = (EntityCreeper)entity).func_70832_p() > 0) {
                return RPLEBlock.of((Block)Blocks.field_150480_ab).rple$getBrightnessColor();
            }
            if (entity instanceof EntityLivingBase) {
                EntityLivingBase living = (EntityLivingBase)entity;
                ItemStack stackMain = living.func_70694_bm();
                short levelMain = ColorDynamicLights.getLightLevel(stackMain);
                ItemStack stackHead = living.func_71124_b(4);
                short levelHead = ColorDynamicLights.getLightLevel(stackHead);
                short level = ServerColorHelper.max(levelMain, levelHead);
                if (living instanceof EntityPlayer) {
                    short levelOffhand = ColorDynamicLights.getLightLevel(OffhandMod.CURRENT.getOffhandItem((EntityPlayer)living));
                    level = ServerColorHelper.max(level, levelOffhand);
                }
                return level;
            }
            if (entity instanceof EntityItemFrame) {
                EntityItemFrame entityItemFrame = (EntityItemFrame)entity;
                ItemStack itemStack = entityItemFrame.func_82335_i();
                return ColorDynamicLights.getLightLevel(itemStack);
            }
            return -1;
        }, 0);
    }

    @Generated
    public ClientProxy() {
    }
}

