/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.rple.internal.proxy;

import com.falsepattern.rple.internal.common.colorizer.BlockColorManager;
import com.falsepattern.rple.internal.common.config.ColorConfigLoader;
import com.falsepattern.rple.internal.common.config.RPLEConfig;
import com.falsepattern.rple.internal.common.event.LumiEventHandler;
import com.falsepattern.rple.internal.common.lamp.LampItemBlock;
import com.falsepattern.rple.internal.common.lamp.Lamps;
import com.falsepattern.rple.internal.common.lamp.RPLELampBlock;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerAboutToStartEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppedEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import lombok.Generated;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public abstract class CommonProxy {
    public void preInit(FMLPreInitializationEvent evt) {
        LumiEventHandler.lumiEventHandler().registerEventHandler();
        for (Lamps lampData : Lamps.values()) {
            String name = lampData.name().toLowerCase();
            RPLELampBlock lamp = new RPLELampBlock(lampData);
            GameRegistry.registerBlock((Block)lamp, LampItemBlock.class, (String)("lamp." + name));
            OreDictionary.registerOre((String)"lampColored", (Block)lamp);
        }
    }

    public void init(FMLInitializationEvent evt) {
        ColorConfigLoader.generateReadmeFile();
        BlockColorManager.blockColorManager().registerBlockColors();
    }

    public void postInit(FMLPostInitializationEvent evt) {
        if (RPLEConfig.General.CRAFTABLE_LAMPS) {
            for (Lamps lampData : Lamps.values()) {
                Block lamp = lampData.findBlock();
                String[] dyes = lampData.dyes;
                ArrayList<Object> recipeArgs = new ArrayList<Object>();
                for (String dye : dyes) {
                    recipeArgs.add(Blocks.field_150379_bu);
                    recipeArgs.add(dye);
                }
                GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(lamp, dyes.length, 0), recipeArgs.toArray()));
                GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(lamp, 1, 1), (Object[])new Object[]{new ItemStack(lamp, 1, 0)});
                GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(lamp, 1, 0), (Object[])new Object[]{new ItemStack(lamp, 1, 1)});
            }
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(Blocks.field_150379_bu, 1, 0), new Object[]{"lampColored", Items.field_151131_as}));
        }
    }

    public void serverAboutToStart(FMLServerAboutToStartEvent evt) {
    }

    public void serverStarting(FMLServerStartingEvent evt) {
    }

    public void serverStarted(FMLServerStartedEvent evt) {
    }

    public void serverStopping(FMLServerStoppingEvent evt) {
    }

    public void serverStopped(FMLServerStoppedEvent evt) {
    }

    @Generated
    public CommonProxy() {
    }
}

