/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.rple.internal.mixin.mixins.client;

import com.falsepattern.rple.api.client.ClientColorHelper;
import com.falsepattern.rple.api.client.CookieMonster;
import com.falsepattern.rple.internal.client.lightmap.LightMap;
import com.falsepattern.rple.internal.client.render.LightValueOverlayRenderer;
import com.falsepattern.rple.internal.common.config.RPLEConfig;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.util.ResourceLocation;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityRenderer.class})
public abstract class EntityRendererMixin
implements IResourceManagerReloadListener {
    @Final
    @Shadow
    private DynamicTexture field_78513_d;
    @Final
    @Shadow
    private ResourceLocation field_110922_T;
    @Final
    @Shadow
    private int[] field_78504_Q;
    @Shadow
    private boolean field_78536_aa;

    @Inject(method={"<init>"}, at={@At(value="RETURN")}, require=1)
    private void setupColorLightMaps(Minecraft minecraft, IResourceManager resourceManager, CallbackInfo ci) {
        LightMap.lightMap().generateTextures();
    }

    @Inject(method={"disableLightmap"}, at={@At(value="HEAD")}, require=1)
    private void disableLightMaps(double p_78463_1_, CallbackInfo ci) {
        LightMap.lightMap().disable();
    }

    @Inject(method={"enableLightmap"}, at={@At(value="HEAD")}, cancellable=true, require=1)
    private void enableLightMaps(double p_78463_1_, CallbackInfo ci) {
        LightMap.lightMap().enable();
        ci.cancel();
    }

    @Inject(method={"updateLightmap"}, at={@At(value="HEAD")}, cancellable=true, require=1)
    private void updateLightMap(float partialTickTime, CallbackInfo ci) {
        LightMap.lightMap().update(partialTickTime);
        this.field_78536_aa = false;
        ci.cancel();
    }

    @Inject(method={"renderWorld"}, at={@At(value="CONSTANT", args={"stringValue=destroyProgress"}, shift=At.Shift.BY, by=-3)}, require=1)
    private void renderLightValueOverlay(float partialTickTime, long expectedFrameDoneTimeNs, CallbackInfo ci) {
        if (RPLEConfig.Debug.RGB_LIGHT_OVERLAY.booleanValue()) {
            LightValueOverlayRenderer.renderLightValueOverlay();
        }
    }

    @WrapOperation(method={"renderRainSnow"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/Tessellator;setBrightness(I)V", ordinal=1)}, require=0, expect=0)
    private void suppressSetBrightness(Tessellator instance, int light, Operation<Void> original) {
    }

    @WrapOperation(method={"renderRainSnow"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/WorldClient;getLightBrightnessForSkyBlocks(IIII)I", ordinal=1)}, require=0, expect=0)
    private int fixSnow1(WorldClient instance, int x, int y, int z, int min, Operation<Integer> original, @Local Tessellator tessellator) {
        Integer brightness = (Integer)original.call(new Object[]{instance, x, y, z, min});
        int shifted = CookieMonster.cookieFromRGB64(ClientColorHelper.RGB64ForEach(CookieMonster.RGB64FromCookie(brightness), c -> (c * 3 + 240) / 4));
        tessellator.func_78380_c(shifted);
        return 0;
    }
}

