/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.votiful.agent;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import me.hsgamer.votiful.data.VoteKey;
import me.hsgamer.votiful.data.VoteTableDiffSnapshot;
import me.hsgamer.votiful.data.VoteTableSnapshot;
import me.hsgamer.votiful.data.VoteValue;
import me.hsgamer.votiful.holder.VoteHolder;
import me.hsgamer.votiful.lib.topper.agent.core.Agent;
import me.hsgamer.votiful.lib.topper.agent.core.DataEntryAgent;
import me.hsgamer.votiful.lib.topper.data.core.DataEntry;

public class VoteStatsAgent
implements Agent,
DataEntryAgent<VoteKey, VoteValue>,
Runnable {
    private final VoteHolder holder;
    private final AtomicBoolean needUpdate = new AtomicBoolean(false);
    private final AtomicReference<VoteTableSnapshot> voteTableSnapshotRef = new AtomicReference<VoteTableSnapshot>(new VoteTableSnapshot());

    public VoteStatsAgent(VoteHolder holder) {
        this.holder = holder;
    }

    private void updateStats(boolean triggerUpdate) {
        VoteTableSnapshot oldSnapshot = this.voteTableSnapshotRef.get();
        VoteTableSnapshot newSnapshot = new VoteTableSnapshot(this.holder.getEntryMap());
        this.voteTableSnapshotRef.set(newSnapshot);
        if (triggerUpdate) {
            this.holder.getVoteEventAgent().triggerUpdate(new VoteTableDiffSnapshot(oldSnapshot, newSnapshot));
        }
    }

    @Override
    public void run() {
        if (!this.needUpdate.getAndSet(false)) {
            return;
        }
        this.updateStats(true);
    }

    @Override
    public void start() {
        this.updateStats(false);
    }

    public VoteTableSnapshot getVoteTableSnapshot() {
        return this.voteTableSnapshotRef.get();
    }

    @Override
    public void onUpdate(DataEntry<VoteKey, VoteValue> entry, VoteValue oldValue, VoteValue newValue) {
        this.needUpdate.lazySet(true);
    }

    @Override
    public void onRemove(DataEntry<VoteKey, VoteValue> entry) {
        this.needUpdate.lazySet(true);
    }
}

