/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.votiful.agent;

import java.util.ArrayList;
import java.util.Map;
import me.hsgamer.votiful.Votiful;
import me.hsgamer.votiful.config.MainConfig;
import me.hsgamer.votiful.data.VoteKey;
import me.hsgamer.votiful.data.VoteValue;
import me.hsgamer.votiful.holder.VoteHolder;
import me.hsgamer.votiful.lib.topper.agent.core.Agent;

public class VoteSyncAgent
implements Agent,
Runnable {
    private final Votiful plugin;
    private final VoteHolder holder;

    public VoteSyncAgent(Votiful plugin, VoteHolder holder) {
        this.plugin = plugin;
        this.holder = holder;
    }

    @Override
    public void run() {
        Map<VoteKey, VoteValue> storageMap = this.holder.getStorageAgent().getStorage().load();
        String serverName = this.plugin.get(MainConfig.class).getServerName();
        ArrayList<VoteKey> toRemove = new ArrayList<VoteKey>();
        for (VoteKey voteKey : this.holder.getEntryMap().keySet()) {
            if (voteKey.serverName.equals(serverName) || storageMap.containsKey(voteKey)) continue;
            toRemove.add(voteKey);
        }
        for (VoteKey voteKey : toRemove) {
            this.holder.removeEntry(voteKey);
        }
        for (Map.Entry entry : storageMap.entrySet()) {
            if (((VoteKey)entry.getKey()).serverName.equals(serverName)) continue;
            this.holder.getOrCreateEntry((VoteKey)entry.getKey()).setValue((VoteValue)entry.getValue());
        }
    }
}

