/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.votiful.config;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import me.hsgamer.votiful.config.converter.StringListConverter;
import me.hsgamer.votiful.config.converter.StringStringObjectMapConverter;
import me.hsgamer.votiful.lib.hscore.config.annotation.Comment;
import me.hsgamer.votiful.lib.hscore.config.annotation.ConfigPath;

public interface MainConfig {
    @ConfigPath(value={"group"})
    @Comment(value={"The group including the server"})
    default public String getGroup() {
        return "default";
    }

    @ConfigPath(value={"server-name"}, priority=1)
    @Comment(value={"The server name"})
    default public String getServerName() {
        return "server";
    }

    @ConfigPath(value={"storage-type"}, priority=2)
    @Comment(value={"The storage type", "Available types: FLAT, MYSQL, SQLITE, NEW-SQLITE, JSON, YAML"})
    default public String getStorageType() {
        return "FLAT";
    }

    @ConfigPath(value={"events"}, converter=StringStringObjectMapConverter.class, priority=3)
    @Comment(value={"The event settings"})
    default public Map<String, Map<String, Object>> getEvents() {
        return Collections.emptyMap();
    }

    @ConfigPath(value={"tasks", "save", "interval"}, priority=4)
    @Comment(value={"The interval in ticks to do the saving task"})
    default public long getTasksSaveInterval() {
        return 10L;
    }

    @ConfigPath(value={"tasks", "save", "entry-per-call"}, priority=4)
    @Comment(value={"The amount of entries to save per call"})
    default public int getTasksSaveEntryPerCall() {
        return 10;
    }

    @ConfigPath(value={"tasks", "sync", "enable"}, priority=4)
    @Comment(value={"Enable the sync task", "This will sync the votes from other servers within the group"})
    default public boolean isTasksSyncEnable() {
        return false;
    }

    @ConfigPath(value={"tasks", "sync", "interval"}, priority=4)
    @Comment(value={"The interval in ticks to do the sync task"})
    default public long getTasksSyncInterval() {
        return 10L;
    }

    @ConfigPath(value={"tasks", "stats", "interval"}, priority=4)
    @Comment(value={"The interval in ticks to do the stats task"})
    default public long getTasksStatsInterval() {
        return 10L;
    }

    @ConfigPath(value={"tasks", "event", "interval"}, priority=4)
    @Comment(value={"The interval in ticks to do the event task"})
    default public long getTasksEventInterval() {
        return 10L;
    }

    @ConfigPath(value={"vote", "offline"}, priority=5)
    @Comment(value={"Should the plugin handle offline votes?"})
    default public boolean isVotesOffline() {
        return false;
    }

    @ConfigPath(value={"vote", "services"}, converter=StringListConverter.class, priority=5)
    @Comment(value={"The accepted vote services", "Use '*' to accept all services"})
    default public List<String> getVoteServices() {
        return Collections.singletonList("*");
    }

    default public boolean isVoteServiceEnabled(String service) {
        List<String> services = this.getVoteServices();
        return services.contains("*") || services.contains(service);
    }
}

