/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.votiful.data;

import java.util.Objects;

public class Vote {
    public final String serviceName;
    public final String playerName;
    public final String address;
    public final long timestamp;

    public Vote(String serviceName, String playerName, String address, long timestamp) {
        this.serviceName = serviceName;
        this.playerName = playerName;
        this.address = address;
        this.timestamp = timestamp;
    }

    public static Vote fromVotifier(com.vexsoftware.votifier.model.Vote vote) {
        long timestamp;
        String serviceName = vote.getServiceName();
        String playerName = vote.getUsername();
        String address = vote.getAddress();
        try {
            timestamp = Long.parseLong(vote.getTimeStamp());
        }
        catch (Exception e) {
            timestamp = System.currentTimeMillis();
        }
        return new Vote(serviceName, playerName, address, timestamp);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vote vote = (Vote)o;
        return this.timestamp == vote.timestamp && Objects.equals(this.serviceName, vote.serviceName) && Objects.equals(this.playerName, vote.playerName) && Objects.equals(this.address, vote.address);
    }

    public int hashCode() {
        return Objects.hash(this.serviceName, this.playerName, this.address, this.timestamp);
    }
}

