/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.votiful.data;

import java.util.Collection;
import java.util.Objects;
import me.hsgamer.votiful.data.VoteTableSnapshot;

public class VoteTableDiffSnapshot {
    public final VoteTableSnapshot oldSnapshot;
    public final VoteTableSnapshot newSnapshot;
    public final long timestamp;

    public VoteTableDiffSnapshot(VoteTableSnapshot oldSnapshot, VoteTableSnapshot newSnapshot) {
        this.oldSnapshot = oldSnapshot;
        this.newSnapshot = newSnapshot;
        this.timestamp = System.currentTimeMillis();
    }

    public VoteTableDiffSnapshot(Collection<VoteTableDiffSnapshot> snapshots) {
        if (snapshots.isEmpty()) {
            throw new IllegalArgumentException("Empty snapshots");
        }
        if (snapshots.size() == 1) {
            VoteTableDiffSnapshot snapshot = snapshots.iterator().next();
            this.oldSnapshot = snapshot.oldSnapshot;
            this.newSnapshot = snapshot.newSnapshot;
            this.timestamp = snapshot.timestamp;
        } else {
            VoteTableSnapshot oldSnapshot = null;
            VoteTableSnapshot newSnapshot = null;
            long oldTimestamp = System.currentTimeMillis();
            long newTimestamp = 0L;
            for (VoteTableDiffSnapshot snapshot : snapshots) {
                if (snapshot.timestamp < oldTimestamp) {
                    oldSnapshot = snapshot.oldSnapshot;
                    oldTimestamp = snapshot.timestamp;
                }
                if (snapshot.timestamp <= newTimestamp) continue;
                newSnapshot = snapshot.newSnapshot;
                newTimestamp = snapshot.timestamp;
            }
            if (oldSnapshot == null || newSnapshot == null) {
                throw new IllegalArgumentException("Invalid snapshots");
            }
            this.oldSnapshot = oldSnapshot;
            this.newSnapshot = newSnapshot;
            this.timestamp = newTimestamp;
        }
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VoteTableDiffSnapshot that = (VoteTableDiffSnapshot)o;
        return this.timestamp == that.timestamp && Objects.equals(this.oldSnapshot, that.oldSnapshot) && Objects.equals(this.newSnapshot, that.newSnapshot);
    }

    public int hashCode() {
        return Objects.hash(this.oldSnapshot, this.newSnapshot, this.timestamp);
    }

    public String toString() {
        return "VoteTableDiffSnapshot{oldSnapshot=" + this.oldSnapshot + ", newSnapshot=" + this.newSnapshot + ", timestamp=" + this.timestamp + '}';
    }
}

