/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.votiful.data;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import me.hsgamer.votiful.data.VoteKey;
import me.hsgamer.votiful.data.VoteValue;
import me.hsgamer.votiful.lib.topper.data.core.DataEntry;

public class VoteTableSnapshot {
    public final Map<VoteKey, VoteValue> entryMap;
    public final int totalVotes;
    public final Map<String, Map<VoteKey, VoteValue>> serverMap;
    public final Map<String, Map<VoteKey, VoteValue>> playerMap;
    public final Map<String, Map<VoteKey, VoteValue>> serviceMap;

    public VoteTableSnapshot() {
        this.entryMap = ImmutableMap.of();
        this.totalVotes = 0;
        this.serverMap = ImmutableMap.of();
        this.playerMap = ImmutableMap.of();
        this.serviceMap = ImmutableMap.of();
    }

    public VoteTableSnapshot(Map<VoteKey, DataEntry<VoteKey, VoteValue>> entryMap) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        int totalVotes = 0;
        HashMap<String, ImmutableMap.Builder> serverMap = new HashMap<String, ImmutableMap.Builder>();
        HashMap<String, ImmutableMap.Builder> playerMap = new HashMap<String, ImmutableMap.Builder>();
        HashMap<String, ImmutableMap.Builder> serviceMap = new HashMap<String, ImmutableMap.Builder>();
        for (Map.Entry<VoteKey, DataEntry<VoteKey, VoteValue>> entry : entryMap.entrySet()) {
            VoteKey key2 = entry.getKey();
            VoteValue value2 = entry.getValue().getValue();
            builder.put((Object)key2, (Object)value2);
            totalVotes += value2.vote;
            serverMap.computeIfAbsent(key2.serverName, k -> ImmutableMap.builder()).put((Object)key2, (Object)value2);
            playerMap.computeIfAbsent(key2.playerName, k -> ImmutableMap.builder()).put((Object)key2, (Object)value2);
            serviceMap.computeIfAbsent(key2.serviceName, k -> ImmutableMap.builder()).put((Object)key2, (Object)value2);
        }
        this.entryMap = builder.build();
        this.totalVotes = totalVotes;
        ImmutableMap.Builder serverMapBuilder = ImmutableMap.builder();
        serverMap.forEach((key, value) -> serverMapBuilder.put(key, (Object)value.build()));
        this.serverMap = serverMapBuilder.build();
        ImmutableMap.Builder playerMapBuilder = ImmutableMap.builder();
        playerMap.forEach((key, value) -> playerMapBuilder.put(key, (Object)value.build()));
        this.playerMap = playerMapBuilder.build();
        ImmutableMap.Builder serviceMapBuilder = ImmutableMap.builder();
        serviceMap.forEach((key, value) -> serviceMapBuilder.put(key, (Object)value.build()));
        this.serviceMap = serviceMapBuilder.build();
    }

    public Map<VoteKey, VoteValue> serverMap(String serverName) {
        return this.serverMap.getOrDefault(serverName, (Map<VoteKey, VoteValue>)ImmutableMap.of());
    }

    public Map<VoteKey, VoteValue> playerMap(String playerName) {
        return this.playerMap.getOrDefault(playerName, (Map<VoteKey, VoteValue>)ImmutableMap.of());
    }

    public Map<VoteKey, VoteValue> serviceMap(String serviceName) {
        return this.serviceMap.getOrDefault(serviceName, (Map<VoteKey, VoteValue>)ImmutableMap.of());
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VoteTableSnapshot that = (VoteTableSnapshot)o;
        return Objects.equals(this.entryMap, that.entryMap);
    }

    public int hashCode() {
        return Objects.hashCode(this.entryMap);
    }

    public String toString() {
        return "VoteTableSnapshot{entryMap=" + this.entryMap + '}';
    }
}

