/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.votiful.data;

import java.util.Objects;
import me.hsgamer.votiful.lib.topper.storage.flat.converter.ComplexFlatValueConverter;
import me.hsgamer.votiful.lib.topper.storage.flat.converter.NumberFlatValueConverter;
import me.hsgamer.votiful.lib.topper.storage.flat.core.FlatValueConverter;
import me.hsgamer.votiful.lib.topper.storage.sql.converter.ComplexSqlValueConverter;
import me.hsgamer.votiful.lib.topper.storage.sql.converter.NumberSqlValueConverter;
import me.hsgamer.votiful.lib.topper.storage.sql.core.SqlValueConverter;

public class VoteValue {
    public static final VoteValue EMPTY = new VoteValue(0, 0L);
    public static final FlatValueConverter<VoteValue> FLAT_CONVERTER = ComplexFlatValueConverter.builder().constructor(() -> EMPTY).entry(new NumberFlatValueConverter<Integer>(Number::intValue), voteValue -> voteValue.vote, (voteValue, value) -> new VoteValue((int)value, voteValue.lastVoteTimestamp)).entry(new NumberFlatValueConverter<Long>(Number::longValue), voteValue -> voteValue.lastVoteTimestamp, (voteValue, value) -> new VoteValue(voteValue.vote, (long)value)).stringSeparator(";").build();
    public static final SqlValueConverter<VoteValue> SQL_CONVERTER = ComplexSqlValueConverter.builder().constructor(() -> EMPTY).entry(new NumberSqlValueConverter<Integer>("vote", false, Number::intValue), voteValue -> voteValue.vote, (voteValue, value) -> new VoteValue((int)value, voteValue.lastVoteTimestamp)).entry(new NumberSqlValueConverter<Long>("lastVoteTimestamp", false, Number::longValue), voteValue -> voteValue.lastVoteTimestamp, (voteValue, value) -> new VoteValue(voteValue.vote, (long)value)).build();
    public final int vote;
    public final long lastVoteTimestamp;

    public VoteValue(int vote, long lastVoteTimestamp) {
        this.vote = vote;
        this.lastVoteTimestamp = lastVoteTimestamp;
    }

    public VoteValue addVote(int vote, long timestamp) {
        return new VoteValue(this.vote + vote, timestamp);
    }

    public VoteValue addVote(long timestamp) {
        return this.addVote(1, timestamp);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VoteValue voteValue = (VoteValue)o;
        return this.vote == voteValue.vote && this.lastVoteTimestamp == voteValue.lastVoteTimestamp;
    }

    public int hashCode() {
        return Objects.hash(this.vote, this.lastVoteTimestamp);
    }

    public String toString() {
        return "VoteValue{vote=" + this.vote + ", lastVoteTimestamp=" + this.lastVoteTimestamp + '}';
    }
}

