/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.votiful.event;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import me.hsgamer.votiful.Votiful;
import me.hsgamer.votiful.config.MainConfig;
import me.hsgamer.votiful.data.VoteKey;
import me.hsgamer.votiful.data.VoteTableDiffSnapshot;
import me.hsgamer.votiful.data.VoteValue;
import me.hsgamer.votiful.event.Event;
import me.hsgamer.votiful.lib.hscore.common.CollectionUtils;
import org.bukkit.plugin.java.JavaPlugin;

public class GlobalEvent
implements Event {
    private final KeyType keyType;
    private final Predicate<VoteKey> voteKeyPredicate;
    private final int voteValue;
    private final boolean repeat;
    private final List<String> commands;

    private GlobalEvent(KeyType keyType, Predicate<VoteKey> voteKeyPredicate, int voteValue, boolean repeat, List<String> commands) {
        this.keyType = keyType;
        this.voteKeyPredicate = voteKeyPredicate;
        this.voteValue = voteValue;
        this.repeat = repeat;
        this.commands = commands;
    }

    public static GlobalEvent create(Map<String, Object> map) {
        int voteValue;
        List<String> serverRules;
        List<String> playerRules;
        KeyType keyType;
        try {
            keyType = KeyType.valueOf(Objects.toString(map.get("key-type")).toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid key type: " + map.get("key-type"));
        }
        Predicate<VoteKey> voteKeyPredicate = key -> true;
        List<String> serviceRules = CollectionUtils.createStringListFromObject(map.get("service-rule"), true);
        if (!serviceRules.isEmpty()) {
            Predicate<VoteKey> servicePredicate = key -> serviceRules.contains(key.serviceName);
            voteKeyPredicate = voteKeyPredicate.and(servicePredicate);
        }
        if (!(playerRules = CollectionUtils.createStringListFromObject(map.get("player-rule"), true)).isEmpty()) {
            Predicate<VoteKey> playerPredicate = key -> playerRules.contains(key.playerName);
            voteKeyPredicate = voteKeyPredicate.and(playerPredicate);
        }
        if (!(serverRules = CollectionUtils.createStringListFromObject(map.get("server-rule"), true)).isEmpty()) {
            boolean hasCurrentServer = serverRules.contains("@current");
            Predicate<VoteKey> serverPredicate = key -> {
                if (hasCurrentServer && key.serverName.equals(((Votiful)JavaPlugin.getPlugin(Votiful.class)).get(MainConfig.class).getServerName())) {
                    return true;
                }
                return serverRules.contains(key.serverName);
            };
            voteKeyPredicate = voteKeyPredicate.and(serverPredicate);
        }
        try {
            voteValue = Integer.parseInt(Objects.toString(map.get("value")));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid vote value: " + map.get("value"));
        }
        boolean repeat = Boolean.parseBoolean(Objects.toString(map.get("repeat")));
        List<String> commands = CollectionUtils.createStringListFromObject(map.get("commands"), true);
        return new GlobalEvent(keyType, voteKeyPredicate, voteValue, repeat, commands);
    }

    private Map<String, Integer> getVoteMap(Map<VoteKey, VoteValue> entryMap, KeyType keyType) {
        return entryMap.entrySet().stream().filter(entry -> this.voteKeyPredicate.test((VoteKey)entry.getKey())).collect(Collectors.toMap(entry -> {
            switch (keyType.ordinal()) {
                case 1: {
                    return ((Votiful)JavaPlugin.getPlugin(Votiful.class)).get(MainConfig.class).getGroup();
                }
                case 2: {
                    return ((VoteKey)entry.getKey()).serviceName;
                }
                case 3: {
                    return ((VoteKey)entry.getKey()).playerName;
                }
                case 0: {
                    return ((VoteKey)entry.getKey()).serverName;
                }
            }
            throw new IllegalStateException("Unexpected value: " + (Object)((Object)keyType));
        }, entry -> ((VoteValue)entry.getValue()).vote, Integer::sum));
    }

    @Override
    public List<String> handle(VoteTableDiffSnapshot snapshot) {
        Map<String, Integer> voteMap = this.getVoteMap(snapshot.newSnapshot.entryMap, this.keyType);
        Map<String, Integer> oldVoteMap = this.getVoteMap(snapshot.oldSnapshot.entryMap, this.keyType);
        HashMap<String, Integer> startMap = new HashMap<String, Integer>();
        for (Map.Entry<String, Integer> entry2 : voteMap.entrySet()) {
            int vote = entry2.getValue();
            int oldVote = oldVoteMap.getOrDefault(entry2.getKey(), 0);
            int voteThreshold = this.repeat ? (oldVote / this.voteValue + 1) * this.voteValue : this.voteValue;
            if (vote < voteThreshold || oldVote >= voteThreshold) continue;
            startMap.put(entry2.getKey(), vote);
        }
        return startMap.entrySet().stream().map(entry -> this.commands.stream().map(s -> s.replace("{key}", (CharSequence)entry.getKey()).replace("{value}", String.valueOf(entry.getValue()))).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public static enum KeyType {
        SERVER,
        GROUP,
        SERVICE,
        PLAYER;

    }
}

