/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.votiful.holder;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Supplier;
import me.hsgamer.votiful.Votiful;
import me.hsgamer.votiful.agent.TaskRunAgent;
import me.hsgamer.votiful.agent.VoteEventAgent;
import me.hsgamer.votiful.agent.VoteStatsAgent;
import me.hsgamer.votiful.agent.VoteSyncAgent;
import me.hsgamer.votiful.config.MainConfig;
import me.hsgamer.votiful.data.Vote;
import me.hsgamer.votiful.data.VoteKey;
import me.hsgamer.votiful.data.VoteValue;
import me.hsgamer.votiful.lib.hscore.bukkit.config.BukkitConfig;
import me.hsgamer.votiful.lib.hscore.config.Config;
import me.hsgamer.votiful.lib.hscore.config.gson.GsonConfig;
import me.hsgamer.votiful.lib.hscore.database.client.sql.java.JavaSqlClient;
import me.hsgamer.votiful.lib.topper.agent.core.Agent;
import me.hsgamer.votiful.lib.topper.agent.core.AgentHolder;
import me.hsgamer.votiful.lib.topper.agent.core.DataEntryAgent;
import me.hsgamer.votiful.lib.topper.agent.storage.StorageAgent;
import me.hsgamer.votiful.lib.topper.data.core.DataEntry;
import me.hsgamer.votiful.lib.topper.data.simple.SimpleDataHolder;
import me.hsgamer.votiful.lib.topper.storage.core.DataStorage;
import me.hsgamer.votiful.lib.topper.storage.flat.configfile.ConfigFileDataStorage;
import me.hsgamer.votiful.lib.topper.storage.flat.properties.PropertiesDataStorage;
import me.hsgamer.votiful.lib.topper.storage.sql.config.SqlDatabaseConfig;
import me.hsgamer.votiful.lib.topper.storage.sql.core.SqlDatabaseSetting;
import me.hsgamer.votiful.lib.topper.storage.sql.mysql.MySqlDataStorageSupplier;
import me.hsgamer.votiful.lib.topper.storage.sql.sqlite.NewSqliteDataStorageSupplier;
import me.hsgamer.votiful.lib.topper.storage.sql.sqlite.SqliteDataStorageSupplier;
import org.bukkit.plugin.Plugin;

public class VoteHolder
extends SimpleDataHolder<VoteKey, VoteValue>
implements AgentHolder<VoteKey, VoteValue> {
    private final Votiful plugin;
    private final String name;
    private final StorageAgent<VoteKey, VoteValue> storageAgent;
    private final VoteStatsAgent voteStatsAgent;
    private final VoteEventAgent voteEventAgent;
    private final List<Agent> agents;
    private final List<DataEntryAgent<VoteKey, VoteValue>> entryAgents;

    public VoteHolder(Votiful plugin, String name) {
        this.plugin = plugin;
        this.name = name;
        this.agents = new ArrayList<Agent>();
        this.entryAgents = new ArrayList<DataEntryAgent<VoteKey, VoteValue>>();
        final MainConfig mainConfig = plugin.get(MainConfig.class);
        this.storageAgent = new StorageAgent<VoteKey, VoteValue>(this.getStorage(mainConfig.getStorageType())){

            @Override
            public void onUpdate(DataEntry<VoteKey, VoteValue> entry, VoteValue oldValue, VoteValue newValue) {
                VoteKey key = entry.getKey();
                if (Objects.equals(key.serverName, mainConfig.getServerName())) {
                    super.onUpdate(entry, oldValue, newValue);
                }
            }
        };
        this.storageAgent.setMaxEntryPerCall(mainConfig.getTasksSaveEntryPerCall());
        this.agents.add(this.storageAgent);
        this.entryAgents.add(this.storageAgent);
        this.agents.add(this.storageAgent.getLoadAgent(this));
        this.agents.add(new TaskRunAgent(plugin, this.storageAgent, mainConfig.getTasksSaveInterval()));
        if (mainConfig.isTasksSyncEnable()) {
            this.agents.add(new TaskRunAgent(plugin, new VoteSyncAgent(plugin, this), mainConfig.getTasksSyncInterval()));
        }
        this.voteStatsAgent = new VoteStatsAgent(this);
        this.agents.add(this.voteStatsAgent);
        this.entryAgents.add(this.voteStatsAgent);
        this.agents.add(new TaskRunAgent(plugin, this.voteStatsAgent, mainConfig.getTasksStatsInterval()));
        this.voteEventAgent = new VoteEventAgent(plugin);
        this.agents.add(new TaskRunAgent(plugin, this.voteEventAgent, mainConfig.getTasksEventInterval()));
    }

    private DataStorage<VoteKey, VoteValue> getStorage(String type) {
        Supplier<SqlDatabaseSetting> databaseSettingSupplier = () -> new SqlDatabaseConfig("votiful", new BukkitConfig((Plugin)this.plugin, "database.yml"));
        Supplier<File> baseFolderSupplier = () -> new File(this.plugin.getDataFolder(), "data");
        switch (type.toLowerCase(Locale.ROOT)) {
            case "mysql": {
                return new MySqlDataStorageSupplier(databaseSettingSupplier.get(), JavaSqlClient::new).getStorage(this.name, VoteKey.SQL_CONVERTER, VoteValue.SQL_CONVERTER);
            }
            case "sqlite": {
                return new SqliteDataStorageSupplier(baseFolderSupplier.get(), databaseSettingSupplier.get(), JavaSqlClient::new).getStorage(this.name, VoteKey.SQL_CONVERTER, VoteValue.SQL_CONVERTER);
            }
            case "new-sqlite": {
                return new NewSqliteDataStorageSupplier(baseFolderSupplier.get(), databaseSettingSupplier.get(), JavaSqlClient::new).getStorage(this.name, VoteKey.SQL_CONVERTER, VoteValue.SQL_CONVERTER);
            }
            case "json": {
                return new ConfigFileDataStorage<VoteKey, VoteValue>(baseFolderSupplier.get(), this.name, VoteKey.FLAT_CONVERTER, VoteValue.FLAT_CONVERTER){

                    @Override
                    protected Config getConfig(File file) {
                        return new GsonConfig(file);
                    }

                    @Override
                    protected String getConfigName(String name) {
                        return name + ".json";
                    }
                };
            }
            case "yaml": {
                return new ConfigFileDataStorage<VoteKey, VoteValue>(baseFolderSupplier.get(), this.name, VoteKey.FLAT_CONVERTER, VoteValue.FLAT_CONVERTER){

                    @Override
                    protected Config getConfig(File file) {
                        return new BukkitConfig(file);
                    }

                    @Override
                    protected String getConfigName(String name) {
                        return name + ".yml";
                    }
                };
            }
        }
        return new PropertiesDataStorage<VoteKey, VoteValue>(baseFolderSupplier.get(), this.name, VoteKey.FLAT_CONVERTER, VoteValue.FLAT_CONVERTER);
    }

    @Override
    public VoteValue getDefaultValue() {
        return VoteValue.EMPTY;
    }

    public StorageAgent<VoteKey, VoteValue> getStorageAgent() {
        return this.storageAgent;
    }

    public VoteStatsAgent getVoteStatsAgent() {
        return this.voteStatsAgent;
    }

    public VoteEventAgent getVoteEventAgent() {
        return this.voteEventAgent;
    }

    public void addVote(Vote vote) {
        VoteKey key = new VoteKey(this.plugin.get(MainConfig.class).getServerName(), vote.playerName, vote.serviceName);
        this.getOrCreateEntry(key).setValue(entry -> entry.addVote(vote.timestamp));
    }

    @Override
    public List<Agent> getAgents() {
        return this.agents;
    }

    @Override
    public List<DataEntryAgent<VoteKey, VoteValue>> getEntryAgents() {
        return this.entryAgents;
    }
}

