/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.votiful.lib.hscore.bukkit.config;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import me.hsgamer.votiful.lib.hscore.config.CommentType;
import me.hsgamer.votiful.lib.hscore.config.Config;
import me.hsgamer.votiful.lib.hscore.config.PathString;
import me.hsgamer.votiful.lib.hscore.logger.common.LogLevel;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class BukkitConfig
implements Config {
    private static boolean isCommentSupported;
    private final File file;
    private final YamlConfiguration configuration = new YamlConfiguration();

    public BukkitConfig(File file) {
        this.file = file;
    }

    public BukkitConfig(Plugin plugin, String filename) {
        this(new File(plugin.getDataFolder(), filename));
        try {
            plugin.saveResource(filename, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public BukkitConfig(Plugin plugin) {
        this(plugin, "config.yml");
    }

    private String toPath(String ... path) {
        return PathString.join(String.valueOf(this.configuration.options().pathSeparator()), path);
    }

    private Map<String[], Object> toPathStringMap(Map<String, Object> map) {
        return PathString.split(String.valueOf(this.configuration.options().pathSeparator()), map);
    }

    public YamlConfiguration getOriginal() {
        return this.configuration;
    }

    @Override
    public Object get(Object def, String ... path) {
        return this.configuration.get(this.toPath(path), def);
    }

    @Override
    public void set(Object value, String ... path) {
        this.configuration.set(this.toPath(path), value);
    }

    @Override
    public boolean contains(String ... path) {
        return this.configuration.isSet(this.toPath(path));
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public Map<String[], Object> getValues(boolean deep, String ... path) {
        if (path.length == 0) {
            return this.toPathStringMap(this.configuration.getValues(deep));
        }
        return Optional.ofNullable(this.configuration.getConfigurationSection(this.toPath(path))).map(configurationSection -> configurationSection.getValues(deep)).map(this::toPathStringMap).orElse(Collections.emptyMap());
    }

    @Override
    public Object normalize(Object object) {
        if (object instanceof ConfigurationSection) {
            return ((ConfigurationSection)object).getValues(false);
        }
        return object;
    }

    @Override
    public boolean isNormalizable(Object object) {
        return object instanceof ConfigurationSection;
    }

    @Override
    public void setup() {
        if (!this.file.exists()) {
            File parentFile = this.file.getAbsoluteFile().getParentFile();
            if (parentFile != null && !parentFile.exists()) {
                parentFile.mkdirs();
            }
            try {
                this.file.createNewFile();
            }
            catch (IOException e) {
                LOGGER.log(LogLevel.WARN, "Something wrong when creating " + this.file.getName(), e);
            }
        }
        try {
            this.configuration.load(this.file);
        }
        catch (IOException | InvalidConfigurationException e) {
            LOGGER.log(LogLevel.WARN, "Something wrong when loading " + this.file.getName(), e);
        }
    }

    @Override
    public void save() {
        try {
            this.configuration.save(this.file);
        }
        catch (IOException e) {
            LOGGER.log(LogLevel.WARN, "Something wrong when saving " + this.file.getName(), e);
        }
    }

    @Override
    public void reload() {
        ArrayList keys = new ArrayList(this.configuration.getKeys(false));
        keys.forEach(key -> this.configuration.set(key, null));
        this.setup();
    }

    @Override
    public List<String> getComment(CommentType type, String ... path) {
        List comments;
        if (path.length == 0) {
            String header = this.configuration.options().header();
            return header.isEmpty() ? Collections.emptyList() : Arrays.asList(header.split("\\r?\\n"));
        }
        if (!isCommentSupported) {
            return Collections.emptyList();
        }
        switch (type) {
            case BLOCK: {
                comments = this.configuration.getComments(this.toPath(path));
                break;
            }
            case SIDE: {
                comments = this.configuration.getInlineComments(this.toPath(path));
                break;
            }
            default: {
                comments = Collections.emptyList();
            }
        }
        return comments;
    }

    @Override
    public void setComment(CommentType type, List<String> value, String ... path) {
        if (path.length == 0) {
            this.configuration.options().copyHeader(true).header(value == null || value.isEmpty() ? null : String.join((CharSequence)System.lineSeparator(), value));
            return;
        }
        if (!isCommentSupported) {
            return;
        }
        switch (type) {
            case BLOCK: {
                this.configuration.setComments(this.toPath(path), value);
                break;
            }
            case SIDE: {
                this.configuration.setInlineComments(this.toPath(path), value);
                break;
            }
        }
    }

    static {
        try {
            isCommentSupported = ConfigurationSection.class.getDeclaredMethod("getComments", String.class) != null;
        }
        catch (NoSuchMethodException e) {
            isCommentSupported = false;
        }
    }
}

