/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.votiful.lib.hscore.common;

import java.util.Arrays;
import java.util.Collection;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface StringReplacer {
    public static final StringReplacer DUMMY = original -> null;

    @NotNull
    public static StringReplacer combine(final @NotNull Collection<? extends StringReplacer> stringReplacers) {
        return new StringReplacer(){

            @Override
            @NotNull
            public String replace(@NotNull String original) {
                String replaced = original;
                for (StringReplacer replacer : stringReplacers) {
                    String newReplaced = replacer.replace(replaced);
                    if (newReplaced == null) continue;
                    replaced = newReplaced;
                }
                return replaced;
            }

            @Override
            @NotNull
            public String replace(@NotNull String original, @NotNull UUID uuid) {
                String replaced = original;
                for (StringReplacer replacer : stringReplacers) {
                    String newReplaced = replacer.replace(replaced, uuid);
                    if (newReplaced == null) continue;
                    replaced = newReplaced;
                }
                return replaced;
            }
        };
    }

    @NotNull
    public static StringReplacer combine(StringReplacer ... stringReplacers) {
        return StringReplacer.combine(Arrays.asList(stringReplacers));
    }

    @NotNull
    public static StringReplacer of(final @NotNull UnaryOperator<String> operator, final @NotNull BiFunction<String, UUID, String> function) {
        return new StringReplacer(){

            @Override
            @Nullable
            public String replace(@NotNull String original) {
                return (String)operator.apply(original);
            }

            @Override
            @Nullable
            public String replace(@NotNull String original, @NotNull UUID uuid) {
                return (String)function.apply(original, uuid);
            }
        };
    }

    @NotNull
    public static StringReplacer of(@NotNull UnaryOperator<String> operator) {
        return operator::apply;
    }

    @NotNull
    public static StringReplacer of(@NotNull BiFunction<String, UUID, String> function) {
        return StringReplacer.of(s -> null, function);
    }

    @Nullable
    public String replace(@NotNull String var1);

    @Nullable
    default public String replace(@NotNull String original, @NotNull UUID uuid) {
        return this.replace(original);
    }

    @Nullable
    default public String tryReplace(@NotNull String original, @Nullable UUID uuid) {
        return uuid == null ? this.replace(original) : this.replace(original, uuid);
    }

    default public String replaceOrDefault(@NotNull String original, @Nullable UUID uuid, @NotNull String def) {
        String replaced = this.tryReplace(original, uuid);
        return replaced != null ? replaced : def;
    }

    default public String replaceOrOriginal(@NotNull String original, @Nullable UUID uuid) {
        return this.replaceOrDefault(original, uuid, original);
    }
}

