/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.votiful.lib.hscore.database.client.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Optional;
import me.hsgamer.votiful.lib.hscore.database.Client;
import me.hsgamer.votiful.lib.hscore.database.client.sql.BatchBuilder;
import me.hsgamer.votiful.lib.hscore.database.client.sql.StatementBuilder;
import me.hsgamer.votiful.lib.hscore.logger.common.LogLevel;
import me.hsgamer.votiful.lib.hscore.logger.provider.LoggerProvider;
import org.intellij.lang.annotations.Language;

public interface SqlClient<T>
extends Client<T> {
    public Connection getConnection() throws SQLException;

    default public StatementBuilder createStatementBuilder() throws SQLException {
        return StatementBuilder.create(this.getConnection());
    }

    default public Optional<StatementBuilder> createStatementBuilderSafe() {
        try {
            return Optional.of(this.createStatementBuilder());
        }
        catch (Exception e) {
            LoggerProvider.getLogger(this.getClass()).log(LogLevel.WARN, e);
            return Optional.empty();
        }
    }

    default public BatchBuilder createBatchBuilder(@Language(value="SQL") String statement) throws SQLException {
        return BatchBuilder.create(this.getConnection(), statement);
    }

    default public Optional<BatchBuilder> createBatchBuilderSafe(@Language(value="SQL") String statement) {
        try {
            return Optional.of(this.createBatchBuilder(statement));
        }
        catch (Exception e) {
            LoggerProvider.getLogger(this.getClass()).log(LogLevel.WARN, e);
            return Optional.empty();
        }
    }
}

