/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.votiful.lib.hscore.database.client.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import me.hsgamer.votiful.lib.hscore.logger.common.LogLevel;
import me.hsgamer.votiful.lib.hscore.logger.common.Logger;
import me.hsgamer.votiful.lib.hscore.logger.provider.LoggerProvider;
import org.intellij.lang.annotations.Language;

public class StatementBuilder {
    private static final Logger LOGGER = LoggerProvider.getLogger(StatementBuilder.class);
    private final Connection connection;
    @Language(value="SQL")
    private String statement;
    private Object[] values;

    private StatementBuilder(Connection connection) {
        this.connection = connection;
    }

    public static StatementBuilder create(Connection connection) {
        return new StatementBuilder(connection);
    }

    public StatementBuilder setStatement(@Language(value="SQL") String statement) {
        this.statement = statement;
        return this;
    }

    public StatementBuilder setValues(Object ... values) {
        this.values = values;
        return this;
    }

    public StatementBuilder setValues(List<Object> values) {
        return this.setValues(values.toArray());
    }

    public StatementBuilder addValues(Object ... values) {
        if (this.values == null || this.values.length == 0) {
            this.values = values;
        } else {
            Object[] newValues = new Object[this.values.length + values.length];
            System.arraycopy(this.values, 0, newValues, 0, this.values.length);
            System.arraycopy(values, 0, newValues, this.values.length, values.length);
            this.values = newValues;
        }
        return this;
    }

    public StatementBuilder addValues(List<Object> values) {
        return this.addValues(values.toArray());
    }

    public <T> T execute(Executor<T> executor) throws SQLException {
        if (this.statement == null) {
            throw new IllegalStateException("Statement is not set");
        }
        try (PreparedStatement preparedStatement = this.connection.prepareStatement(this.statement);){
            if (this.values != null) {
                for (int i = 0; i < this.values.length; ++i) {
                    preparedStatement.setObject(i + 1, this.values[i]);
                }
            }
            T t = executor.apply(preparedStatement);
            return t;
        }
    }

    public <T> T query(ResultSetConverter<T> converter) throws SQLException {
        return (T)this.execute(preparedStatement -> {
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                Object t = converter.apply(resultSet);
                return t;
            }
        });
    }

    public <T> List<T> queryList(ResultSetConverter<T> converter) throws SQLException {
        return this.query(resultSet -> {
            ArrayList list = new ArrayList();
            while (resultSet.next()) {
                list.add(converter.apply(resultSet));
            }
            return list;
        });
    }

    public void consume(ResultSetConsumer consumer) throws SQLException {
        this.execute(preparedStatement -> {
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                consumer.accept(resultSet);
            }
            return null;
        });
    }

    public int update() throws SQLException {
        return this.execute(PreparedStatement::executeUpdate);
    }

    public <T> Optional<T> querySafe(ResultSetConverter<T> converter) {
        try {
            return Optional.of(this.query(converter));
        }
        catch (SQLException e) {
            LOGGER.log(LogLevel.WARN, e);
            return Optional.empty();
        }
    }

    public <T> Optional<List<T>> queryListSafe(ResultSetConverter<T> converter) {
        try {
            return Optional.of(this.queryList(converter));
        }
        catch (SQLException e) {
            LOGGER.log(LogLevel.WARN, e);
            return Optional.empty();
        }
    }

    public void consumeSafe(ResultSetConsumer consumer) {
        try {
            this.consume(consumer);
        }
        catch (SQLException e) {
            LOGGER.log(LogLevel.WARN, e);
        }
    }

    public int updateSafe() {
        try {
            return this.update();
        }
        catch (SQLException e) {
            LOGGER.log(LogLevel.WARN, e);
            return -1;
        }
    }

    public static interface Executor<T> {
        public T apply(PreparedStatement var1) throws SQLException;
    }

    public static interface ResultSetConverter<T> {
        public T apply(ResultSet var1) throws SQLException;
    }

    public static interface ResultSetConsumer {
        public void accept(ResultSet var1) throws SQLException;
    }
}

