/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.votiful.lib.hscore.database.driver.mysql;

import me.hsgamer.votiful.lib.hscore.database.Driver;
import me.hsgamer.votiful.lib.hscore.database.Setting;

public class MySqlDriver
implements Driver {
    @Override
    public Class<? extends java.sql.Driver> getDriverClass() {
        try {
            return com.mysql.cj.jdbc.Driver.class;
        }
        catch (ExceptionInInitializerError | NoClassDefFoundError e) {
            try {
                return Class.forName("com.mysql.jdbc.Driver").asSubclass(java.sql.Driver.class);
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalStateException("Cannot find the driver class", ex);
            }
        }
    }

    @Override
    public String convertURL(Setting setting) {
        return "jdbc:mysql://" + setting.getNormalizedHost() + '/' + setting.getDatabaseName() + Driver.createPropertyString(setting);
    }

    @Override
    public void applyDefaultSetting(Setting setting) {
        setting.setPort("3306").setUsername("root");
    }
}

