/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.votiful.lib.hscore.gson;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.internal.LinkedTreeMap;
import com.google.gson.stream.JsonReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class GsonUtils {
    private static final boolean IS_PARSER_STATIC;

    private GsonUtils() {
    }

    public static JsonElement parse(String string) {
        if (IS_PARSER_STATIC) {
            return JsonParser.parseString((String)string);
        }
        JsonParser parser = new JsonParser();
        return parser.parse(string);
    }

    public static JsonElement parse(Reader reader) {
        if (IS_PARSER_STATIC) {
            return JsonParser.parseReader((Reader)reader);
        }
        JsonParser parser = new JsonParser();
        return parser.parse(reader);
    }

    public static JsonElement parse(JsonReader reader) {
        if (IS_PARSER_STATIC) {
            return JsonParser.parseReader((JsonReader)reader);
        }
        JsonParser parser = new JsonParser();
        return parser.parse(reader);
    }

    public static List<JsonElement> getElements(JsonArray array) {
        ArrayList<JsonElement> elements = new ArrayList<JsonElement>();
        for (JsonElement element : array) {
            elements.add(element);
        }
        return elements;
    }

    public static boolean isEmpty(JsonArray array) {
        return array == null || array.size() == 0;
    }

    public static Map<String, JsonElement> getElements(JsonObject object) {
        LinkedTreeMap elements = new LinkedTreeMap();
        for (Map.Entry entry : object.entrySet()) {
            elements.put((String)entry.getKey(), (JsonElement)entry.getValue());
        }
        return elements;
    }

    public static Object normalize(JsonElement element, boolean deep) {
        if (element.isJsonPrimitive()) {
            JsonPrimitive jsonPrimitive = element.getAsJsonPrimitive();
            if (jsonPrimitive.isBoolean()) {
                return jsonPrimitive.getAsBoolean();
            }
            if (jsonPrimitive.isNumber()) {
                return jsonPrimitive.getAsNumber();
            }
            if (jsonPrimitive.isString()) {
                return jsonPrimitive.getAsString();
            }
        } else {
            if (element.isJsonArray()) {
                JsonArray jsonArray = element.getAsJsonArray();
                if (deep) {
                    ArrayList<Object> list = new ArrayList<Object>();
                    for (JsonElement jsonElement : jsonArray) {
                        list.add(GsonUtils.normalize(jsonElement, true));
                    }
                    return list;
                }
                return GsonUtils.getElements(jsonArray);
            }
            if (element.isJsonObject()) {
                JsonObject jsonObject = element.getAsJsonObject();
                if (deep) {
                    LinkedTreeMap map = new LinkedTreeMap();
                    for (Map.Entry entry : jsonObject.entrySet()) {
                        map.put((String)entry.getKey(), GsonUtils.normalize((JsonElement)entry.getValue(), true));
                    }
                    return map;
                }
                return GsonUtils.getElements(jsonObject);
            }
            if (element.isJsonNull()) {
                return null;
            }
        }
        return element.getAsString();
    }

    static {
        boolean isParserStatic;
        try {
            JsonParser.class.getDeclaredMethod("parseString", String.class);
            isParserStatic = true;
        }
        catch (NoSuchMethodException e) {
            isParserStatic = false;
        }
        IS_PARSER_STATIC = isParserStatic;
    }
}

